/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.aop.aspectj;

import com.bea.core.repackaged.springframework.aop.aspectj.AspectInstanceFactory;
import com.bea.core.repackaged.springframework.aop.framework.AopConfigException;
import com.bea.core.repackaged.springframework.util.Assert;

public class SimpleAspectInstanceFactory
implements AspectInstanceFactory {
    private final Class aspectClass;

    public SimpleAspectInstanceFactory(Class aspectClass) {
        Assert.notNull(aspectClass, "Aspect class must not be null");
        this.aspectClass = aspectClass;
    }

    public final Class getAspectClass() {
        return this.aspectClass;
    }

    public final Object getAspectInstance() {
        try {
            return this.aspectClass.newInstance();
        }
        catch (InstantiationException ex) {
            throw new AopConfigException("Unable to instantiate aspect class [" + this.aspectClass.getName() + "]", ex);
        }
        catch (IllegalAccessException ex) {
            throw new AopConfigException("Cannot access element class [" + this.aspectClass.getName() + "]", ex);
        }
    }

    public ClassLoader getAspectClassLoader() {
        return this.aspectClass.getClassLoader();
    }

    public int getOrder() {
        return this.getOrderForAspectClass(this.aspectClass);
    }

    protected int getOrderForAspectClass(Class aspectClass) {
        return Integer.MAX_VALUE;
    }
}

