/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.aop.aspectj.autoproxy;

import com.bea.core.repackaged.springframework.aop.Advisor;
import com.bea.core.repackaged.springframework.aop.aspectj.AspectJAopUtils;
import com.bea.core.repackaged.springframework.aop.aspectj.AspectJPrecedenceInformation;
import com.bea.core.repackaged.springframework.core.OrderComparator;
import com.bea.core.repackaged.springframework.util.Assert;
import java.util.Comparator;

class AspectJPrecedenceComparator
implements Comparator {
    private static final int HIGHER_PRECEDENCE = -1;
    private static final int SAME_PRECEDENCE = 0;
    private static final int LOWER_PRECEDENCE = 1;
    private static final int NOT_COMPARABLE = 0;
    private final Comparator advisorComparator;

    public AspectJPrecedenceComparator() {
        this.advisorComparator = new OrderComparator();
    }

    public AspectJPrecedenceComparator(Comparator advisorComparator) {
        Assert.notNull(advisorComparator, "Advisor comparator must not be null");
        this.advisorComparator = advisorComparator;
    }

    public int compare(Object o1, Object o2) {
        boolean oneOrOtherIsBeforeAdvice;
        if (!(o1 instanceof Advisor) || !(o2 instanceof Advisor)) {
            throw new IllegalArgumentException("AspectJPrecedenceComparator can only compare the order of Advisors, but was passed [" + o1 + "] and [" + o2 + "]");
        }
        Advisor advisor1 = (Advisor)o1;
        Advisor advisor2 = (Advisor)o2;
        boolean oneOrOtherIsAfterAdvice = AspectJAopUtils.isAfterAdvice(advisor1) || AspectJAopUtils.isAfterAdvice(advisor2);
        boolean bl = oneOrOtherIsBeforeAdvice = AspectJAopUtils.isBeforeAdvice(advisor1) || AspectJAopUtils.isBeforeAdvice(advisor2);
        if (oneOrOtherIsAfterAdvice && oneOrOtherIsBeforeAdvice) {
            return 0;
        }
        int advisorPrecedence = this.advisorComparator.compare(advisor1, advisor2);
        if (advisorPrecedence == 0 && this.declaredInSameAspect(advisor1, advisor2)) {
            advisorPrecedence = this.comparePrecedenceWithinAspect(advisor1, advisor2);
        }
        return advisorPrecedence;
    }

    private int comparePrecedenceWithinAspect(Advisor advisor1, Advisor advisor2) {
        boolean oneOrOtherIsAfterAdvice = AspectJAopUtils.isAfterAdvice(advisor1) || AspectJAopUtils.isAfterAdvice(advisor2);
        int adviceDeclarationOrderDelta = this.getAspectDeclarationOrder(advisor1) - this.getAspectDeclarationOrder(advisor2);
        if (oneOrOtherIsAfterAdvice) {
            if (adviceDeclarationOrderDelta < 0) {
                return 1;
            }
            if (adviceDeclarationOrderDelta == 0) {
                return 0;
            }
            return -1;
        }
        if (adviceDeclarationOrderDelta < 0) {
            return -1;
        }
        if (adviceDeclarationOrderDelta == 0) {
            return 0;
        }
        return 1;
    }

    private boolean declaredInSameAspect(Advisor advisor1, Advisor advisor2) {
        if (!this.hasAspectName(advisor1) || !this.hasAspectName(advisor2)) {
            return false;
        }
        return this.getAspectName(advisor1).equals(this.getAspectName(advisor2));
    }

    private boolean hasAspectName(Advisor anAdvisor) {
        return anAdvisor instanceof AspectJPrecedenceInformation || anAdvisor.getAdvice() instanceof AspectJPrecedenceInformation;
    }

    private String getAspectName(Advisor anAdvisor) {
        return AspectJAopUtils.getAspectJPrecedenceInformationFor(anAdvisor).getAspectName();
    }

    private int getAspectDeclarationOrder(Advisor anAdvisor) {
        AspectJPrecedenceInformation precedenceInfo = AspectJAopUtils.getAspectJPrecedenceInformationFor(anAdvisor);
        if (precedenceInfo != null) {
            return precedenceInfo.getDeclarationOrder();
        }
        return 0;
    }
}

