/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.aop.config;

import com.bea.core.repackaged.springframework.aop.config.AopConfigUtils;
import com.bea.core.repackaged.springframework.beans.factory.config.BeanDefinition;
import com.bea.core.repackaged.springframework.beans.factory.parsing.BeanComponentDefinition;
import com.bea.core.repackaged.springframework.beans.factory.support.BeanDefinitionRegistry;
import com.bea.core.repackaged.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public abstract class AopNamespaceUtils {
    public static final String PROXY_TARGET_CLASS_ATTRIBUTE = "proxy-target-class";

    public static void registerAutoProxyCreatorIfNecessary(ParserContext parserContext, Element sourceElement) {
        BeanDefinition beanDefinition = AopConfigUtils.registerAutoProxyCreatorIfNecessary(parserContext.getRegistry(), parserContext.extractSource(sourceElement));
        AopNamespaceUtils.useClassProxyingIfNecessary(parserContext.getRegistry(), sourceElement);
        AopNamespaceUtils.registerComponentIfNecessary(beanDefinition, parserContext);
    }

    public static void registerAspectJAutoProxyCreatorIfNecessary(ParserContext parserContext, Element sourceElement) {
        BeanDefinition beanDefinition = AopConfigUtils.registerAspectJAutoProxyCreatorIfNecessary(parserContext.getRegistry(), parserContext.extractSource(sourceElement));
        AopNamespaceUtils.useClassProxyingIfNecessary(parserContext.getRegistry(), sourceElement);
        AopNamespaceUtils.registerComponentIfNecessary(beanDefinition, parserContext);
    }

    public static void registerAspectJAnnotationAutoProxyCreatorIfNecessary(ParserContext parserContext, Element sourceElement) {
        BeanDefinition beanDefinition = AopConfigUtils.registerAspectJAnnotationAutoProxyCreatorIfNecessary(parserContext.getRegistry(), parserContext.extractSource(sourceElement));
        AopNamespaceUtils.useClassProxyingIfNecessary(parserContext.getRegistry(), sourceElement);
        AopNamespaceUtils.registerComponentIfNecessary(beanDefinition, parserContext);
    }

    public static void registerAutoProxyCreatorIfNecessary(ParserContext parserContext, Object source) {
        BeanDefinition beanDefinition = AopConfigUtils.registerAutoProxyCreatorIfNecessary(parserContext.getRegistry(), source);
        AopNamespaceUtils.registerComponentIfNecessary(beanDefinition, parserContext);
    }

    public static void forceAutoProxyCreatorToUseClassProxying(BeanDefinitionRegistry registry) {
        AopConfigUtils.forceAutoProxyCreatorToUseClassProxying(registry);
    }

    private static void useClassProxyingIfNecessary(BeanDefinitionRegistry registry, Element sourceElement) {
        boolean proxyTargetClass;
        if (sourceElement != null && (proxyTargetClass = Boolean.valueOf(sourceElement.getAttribute(PROXY_TARGET_CLASS_ATTRIBUTE)).booleanValue())) {
            AopConfigUtils.forceAutoProxyCreatorToUseClassProxying(registry);
        }
    }

    private static void registerComponentIfNecessary(BeanDefinition beanDefinition, ParserContext parserContext) {
        if (beanDefinition != null) {
            BeanComponentDefinition componentDefinition = new BeanComponentDefinition(beanDefinition, "com.bea.core.repackaged.springframework.aop.config.internalAutoProxyCreator");
            parserContext.registerComponent(componentDefinition);
        }
    }
}

