/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.aop.framework;

import com.bea.core.repackaged.springframework.aop.SpringProxy;
import com.bea.core.repackaged.springframework.aop.framework.AdvisedSupport;
import com.bea.core.repackaged.springframework.aop.framework.AopConfigException;
import com.bea.core.repackaged.springframework.aop.framework.AopProxy;
import com.bea.core.repackaged.springframework.aop.framework.AopProxyFactory;
import com.bea.core.repackaged.springframework.aop.framework.Cglib2AopProxy;
import com.bea.core.repackaged.springframework.aop.framework.JdkDynamicAopProxy;
import com.bea.core.repackaged.springframework.util.ClassUtils;
import java.io.Serializable;

public class DefaultAopProxyFactory
implements AopProxyFactory,
Serializable {
    private static final boolean cglibAvailable = ClassUtils.isPresent("net.sf.cglib.proxy.Enhancer", DefaultAopProxyFactory.class.getClassLoader());

    public AopProxy createAopProxy(AdvisedSupport config) throws AopConfigException {
        if (config.isOptimize() || config.isProxyTargetClass() || this.hasNoUserSuppliedProxyInterfaces(config)) {
            Class targetClass = config.getTargetClass();
            if (targetClass == null) {
                throw new AopConfigException("TargetSource cannot determine target class: Either an interface or a target is required for proxy creation.");
            }
            if (targetClass.isInterface()) {
                return new JdkDynamicAopProxy(config);
            }
            if (!cglibAvailable) {
                throw new AopConfigException("Cannot proxy target class because CGLIB2 is not available. Add CGLIB to the class path or specify proxy interfaces.");
            }
            return CglibProxyFactory.createCglibProxy(config);
        }
        return new JdkDynamicAopProxy(config);
    }

    private boolean hasNoUserSuppliedProxyInterfaces(AdvisedSupport config) {
        Class[] interfaces = config.getProxiedInterfaces();
        return interfaces.length == 0 || interfaces.length == 1 && SpringProxy.class.equals(interfaces[0]);
    }

    private static class CglibProxyFactory {
        private CglibProxyFactory() {
        }

        public static AopProxy createCglibProxy(AdvisedSupport advisedSupport) {
            return new Cglib2AopProxy(advisedSupport);
        }
    }
}

