/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.aop.framework;

import com.bea.core.repackaged.apache.commons.logging.Log;
import com.bea.core.repackaged.apache.commons.logging.LogFactory;
import com.bea.core.repackaged.springframework.aop.RawTargetAccess;
import com.bea.core.repackaged.springframework.aop.TargetSource;
import com.bea.core.repackaged.springframework.aop.framework.Advised;
import com.bea.core.repackaged.springframework.aop.framework.AdvisedSupport;
import com.bea.core.repackaged.springframework.aop.framework.AopConfigException;
import com.bea.core.repackaged.springframework.aop.framework.AopContext;
import com.bea.core.repackaged.springframework.aop.framework.AopProxy;
import com.bea.core.repackaged.springframework.aop.framework.AopProxyUtils;
import com.bea.core.repackaged.springframework.aop.framework.ReflectiveMethodInvocation;
import com.bea.core.repackaged.springframework.aop.support.AopUtils;
import com.bea.core.repackaged.springframework.util.Assert;
import com.bea.core.repackaged.springframework.util.ClassUtils;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;

public final class JdkDynamicAopProxy
implements AopProxy,
InvocationHandler,
Serializable {
    private static final long serialVersionUID = 5531744639992436476L;
    private static Log logger = LogFactory.getLog(JdkDynamicAopProxy.class);
    public final AdvisedSupport advised;
    private boolean equalsDefined;
    private boolean hashCodeDefined;

    public JdkDynamicAopProxy(AdvisedSupport advisedSupport) throws AopConfigException {
        Assert.notNull(advisedSupport, "AdvisedSupport must not be null");
        if (advisedSupport.getAdvisors().length == 0 && advisedSupport.getTargetSource() == AdvisedSupport.EMPTY_TARGET_SOURCE) {
            throw new AopConfigException("No advisors and no TargetSource specified");
        }
        this.advised = advisedSupport;
    }

    @Override
    public Object getProxy() {
        return this.getProxy(ClassUtils.getDefaultClassLoader());
    }

    @Override
    public Object getProxy(ClassLoader classLoader) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating JDK dynamic proxy: target source is " + this.advised.getTargetSource()));
        }
        Class[] classArray = AopProxyUtils.completeProxiedInterfaces(this.advised);
        this.findDefinedEqualsAndHashCodeMethods(classArray);
        return Proxy.newProxyInstance(classLoader, classArray, (InvocationHandler)this);
    }

    private void findDefinedEqualsAndHashCodeMethods(Class[] classArray) {
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz = classArray[i];
            Method[] methodArray = clazz.getDeclaredMethods();
            for (int j = 0; j < methodArray.length; ++j) {
                Method method = methodArray[j];
                if (AopUtils.isEqualsMethod(method)) {
                    this.equalsDefined = true;
                }
                if (AopUtils.isHashCodeMethod(method)) {
                    this.hashCodeDefined = true;
                }
                if (!this.equalsDefined || !this.hashCodeDefined) continue;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Object object2;
        boolean bl;
        Object object3;
        block22: {
            List list;
            Object object4;
            Class<?> clazz;
            TargetSource targetSource;
            ReflectiveMethodInvocation reflectiveMethodInvocation;
            block20: {
                Object object5;
                block21: {
                    block18: {
                        Integer n;
                        block19: {
                            block16: {
                                Boolean bl2;
                                block17: {
                                    reflectiveMethodInvocation = null;
                                    object3 = null;
                                    bl = false;
                                    targetSource = this.advised.targetSource;
                                    clazz = null;
                                    object4 = null;
                                    try {
                                        if (this.equalsDefined || !AopUtils.isEqualsMethod(method)) break block16;
                                        Boolean bl3 = bl2 = this.equals(objectArray[0]) ? Boolean.TRUE : Boolean.FALSE;
                                        if (object4 == null || targetSource.isStatic()) break block17;
                                    }
                                    catch (Throwable throwable) {
                                        if (object4 != null && !targetSource.isStatic()) {
                                            targetSource.releaseTarget(object4);
                                        }
                                        if (bl) {
                                            AopContext.setCurrentProxy(object3);
                                        }
                                        throw throwable;
                                    }
                                    targetSource.releaseTarget(object4);
                                }
                                if (bl) {
                                    AopContext.setCurrentProxy(object3);
                                }
                                return bl2;
                            }
                            if (this.hashCodeDefined || !AopUtils.isHashCodeMethod(method)) break block18;
                            n = new Integer(this.hashCode());
                            if (object4 == null || targetSource.isStatic()) break block19;
                            targetSource.releaseTarget(object4);
                        }
                        if (bl) {
                            AopContext.setCurrentProxy(object3);
                        }
                        return n;
                    }
                    if (this.advised.opaque || !method.getDeclaringClass().isInterface() || !method.getDeclaringClass().isAssignableFrom(Advised.class)) break block20;
                    object5 = AopUtils.invokeJoinpointUsingReflection(this.advised, method, objectArray);
                    if (object4 == null || targetSource.isStatic()) break block21;
                    targetSource.releaseTarget(object4);
                }
                if (bl) {
                    AopContext.setCurrentProxy(object3);
                }
                return object5;
            }
            Object object6 = null;
            if (this.advised.exposeProxy) {
                object3 = AopContext.setCurrentProxy(object);
                bl = true;
            }
            if ((object4 = targetSource.getTarget()) != null) {
                clazz = object4.getClass();
            }
            if ((list = this.advised.getInterceptorsAndDynamicInterceptionAdvice(method, clazz)).isEmpty()) {
                object6 = AopUtils.invokeJoinpointUsingReflection(object4, method, objectArray);
            } else {
                reflectiveMethodInvocation = new ReflectiveMethodInvocation(object, object4, method, objectArray, clazz, list);
                object6 = reflectiveMethodInvocation.proceed();
            }
            if (object6 != null && object6 == object4 && method.getReturnType().isInstance(object) && !RawTargetAccess.class.isAssignableFrom(method.getDeclaringClass())) {
                object6 = object;
            }
            object2 = object6;
            if (object4 == null || targetSource.isStatic()) break block22;
            targetSource.releaseTarget(object4);
        }
        if (bl) {
            AopContext.setCurrentProxy(object3);
        }
        return object2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        JdkDynamicAopProxy jdkDynamicAopProxy = null;
        if (object instanceof JdkDynamicAopProxy) {
            jdkDynamicAopProxy = (JdkDynamicAopProxy)object;
        } else if (Proxy.isProxyClass(object.getClass())) {
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(object);
            if (!(invocationHandler instanceof JdkDynamicAopProxy)) {
                return false;
            }
            jdkDynamicAopProxy = (JdkDynamicAopProxy)invocationHandler;
        } else {
            return false;
        }
        return AopProxyUtils.equalsInProxy(this.advised, jdkDynamicAopProxy.advised);
    }

    public int hashCode() {
        return JdkDynamicAopProxy.class.hashCode() * 13 + this.advised.getTargetSource().hashCode();
    }
}

