/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.aop.framework.autoproxy;

import com.bea.core.repackaged.springframework.aop.TargetSource;
import com.bea.core.repackaged.springframework.aop.framework.autoproxy.AbstractAutoProxyCreator;
import com.bea.core.repackaged.springframework.aop.framework.autoproxy.BeanFactoryAdvisorRetrievalHelper;
import com.bea.core.repackaged.springframework.aop.framework.autoproxy.ProxyCreationContext;
import com.bea.core.repackaged.springframework.aop.support.AopUtils;
import com.bea.core.repackaged.springframework.beans.factory.BeanFactory;
import com.bea.core.repackaged.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import com.bea.core.repackaged.springframework.core.OrderComparator;
import java.util.Collections;
import java.util.List;

public abstract class AbstractAdvisorAutoProxyCreator
extends AbstractAutoProxyCreator {
    private BeanFactoryAdvisorRetrievalHelper advisorRetrievalHelper;

    public void setBeanFactory(BeanFactory beanFactory) {
        super.setBeanFactory(beanFactory);
        if (!(beanFactory instanceof ConfigurableListableBeanFactory)) {
            throw new IllegalStateException("Cannot use AdvisorAutoProxyCreator without a ConfigurableListableBeanFactory");
        }
        this.initBeanFactory((ConfigurableListableBeanFactory)beanFactory);
    }

    protected void initBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        this.advisorRetrievalHelper = new BeanFactoryAdvisorRetrievalHelperAdapter(beanFactory);
    }

    protected Object[] getAdvicesAndAdvisorsForBean(Class beanClass, String beanName, TargetSource targetSource) {
        List advisors = this.findEligibleAdvisors(beanClass, beanName);
        if (advisors.isEmpty()) {
            return DO_NOT_PROXY;
        }
        return advisors.toArray();
    }

    protected List findEligibleAdvisors(Class beanClass, String beanName) {
        List candidateAdvisors = this.findCandidateAdvisors();
        List eligibleAdvisors = this.findAdvisorsThatCanApply(candidateAdvisors, beanClass, beanName);
        if (!eligibleAdvisors.isEmpty()) {
            eligibleAdvisors = this.sortAdvisors(eligibleAdvisors);
        }
        this.extendAdvisors(eligibleAdvisors);
        return eligibleAdvisors;
    }

    protected List findCandidateAdvisors() {
        return this.advisorRetrievalHelper.findAdvisorBeans();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List findAdvisorsThatCanApply(List candidateAdvisors, Class beanClass, String beanName) {
        List list;
        ProxyCreationContext.setCurrentProxiedBeanName(beanName);
        try {
            list = AopUtils.findAdvisorsThatCanApply(candidateAdvisors, beanClass);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            ProxyCreationContext.setCurrentProxiedBeanName(null);
            throw throwable;
        }
        ProxyCreationContext.setCurrentProxiedBeanName(null);
        return list;
    }

    protected boolean isEligibleAdvisorBean(String beanName) {
        return true;
    }

    protected List sortAdvisors(List advisors) {
        Collections.sort(advisors, new OrderComparator());
        return advisors;
    }

    protected void extendAdvisors(List candidateAdvisors) {
    }

    protected boolean advisorsPreFiltered() {
        return true;
    }

    private class BeanFactoryAdvisorRetrievalHelperAdapter
    extends BeanFactoryAdvisorRetrievalHelper {
        public BeanFactoryAdvisorRetrievalHelperAdapter(ConfigurableListableBeanFactory beanFactory) {
            super(beanFactory);
        }

        protected boolean isEligibleBean(String beanName) {
            return AbstractAdvisorAutoProxyCreator.this.isEligibleAdvisorBean(beanName);
        }
    }
}

