/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.aop.framework.autoproxy;

import com.bea.core.repackaged.apache.commons.logging.Log;
import com.bea.core.repackaged.apache.commons.logging.LogFactory;
import com.bea.core.repackaged.springframework.aop.Advisor;
import com.bea.core.repackaged.springframework.beans.factory.BeanCreationException;
import com.bea.core.repackaged.springframework.beans.factory.BeanCurrentlyInCreationException;
import com.bea.core.repackaged.springframework.beans.factory.BeanFactoryUtils;
import com.bea.core.repackaged.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import com.bea.core.repackaged.springframework.util.Assert;
import java.util.LinkedList;
import java.util.List;

public class BeanFactoryAdvisorRetrievalHelper {
    private static final Log logger = LogFactory.getLog((Class)BeanFactoryAdvisorRetrievalHelper.class);
    private final ConfigurableListableBeanFactory beanFactory;
    private String[] cachedAdvisorBeanNames;

    public BeanFactoryAdvisorRetrievalHelper(ConfigurableListableBeanFactory beanFactory) {
        Assert.notNull(beanFactory, "ListableBeanFactory must not be null");
        this.beanFactory = beanFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List findAdvisorBeans() {
        String[] advisorNames = null;
        BeanFactoryAdvisorRetrievalHelper beanFactoryAdvisorRetrievalHelper = this;
        synchronized (beanFactoryAdvisorRetrievalHelper) {
            advisorNames = this.cachedAdvisorBeanNames;
            if (advisorNames == null) {
                this.cachedAdvisorBeanNames = advisorNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors(this.beanFactory, Advisor.class, true, false);
            }
        }
        if (advisorNames.length == 0) {
            return new LinkedList();
        }
        LinkedList<Object> advisors = new LinkedList<Object>();
        for (int i = 0; i < advisorNames.length; ++i) {
            String name = advisorNames[i];
            if (!this.isEligibleBean(name) || this.beanFactory.isCurrentlyInCreation(name)) continue;
            try {
                advisors.add(this.beanFactory.getBean(name));
                continue;
            }
            catch (BeanCreationException ex) {
                BeanCreationException bce;
                Throwable rootCause = ex.getMostSpecificCause();
                if (rootCause instanceof BeanCurrentlyInCreationException && this.beanFactory.isCurrentlyInCreation((bce = (BeanCreationException)rootCause).getBeanName())) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Ignoring currently created advisor '" + name + "': " + ex.getMessage()));
                    continue;
                }
                throw ex;
            }
        }
        return advisors;
    }

    protected boolean isEligibleBean(String beanName) {
        return true;
    }
}

