/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.aop.scope;

import com.bea.core.repackaged.springframework.aop.framework.autoproxy.AutoProxyUtils;
import com.bea.core.repackaged.springframework.aop.scope.ScopedProxyFactoryBean;
import com.bea.core.repackaged.springframework.beans.factory.config.BeanDefinition;
import com.bea.core.repackaged.springframework.beans.factory.config.BeanDefinitionHolder;
import com.bea.core.repackaged.springframework.beans.factory.support.BeanDefinitionRegistry;
import com.bea.core.repackaged.springframework.beans.factory.support.RootBeanDefinition;

public abstract class ScopedProxyUtils {
    private static final String TARGET_NAME_PREFIX = "scopedTarget.";

    public static BeanDefinitionHolder createScopedProxy(BeanDefinitionHolder definition, BeanDefinitionRegistry registry, boolean proxyTargetClass) {
        String originalBeanName = definition.getBeanName();
        BeanDefinition targetDefinition = definition.getBeanDefinition();
        RootBeanDefinition scopedProxyDefinition = new RootBeanDefinition(ScopedProxyFactoryBean.class);
        scopedProxyDefinition.setOriginatingBeanDefinition(definition.getBeanDefinition());
        scopedProxyDefinition.setSource(definition.getSource());
        String targetBeanName = TARGET_NAME_PREFIX + originalBeanName;
        scopedProxyDefinition.getPropertyValues().addPropertyValue("targetBeanName", targetBeanName);
        if (proxyTargetClass) {
            targetDefinition.setAttribute(AutoProxyUtils.PRESERVE_TARGET_CLASS_ATTRIBUTE, Boolean.TRUE);
        } else {
            scopedProxyDefinition.getPropertyValues().addPropertyValue("proxyTargetClass", Boolean.FALSE);
        }
        scopedProxyDefinition.setAutowireCandidate(targetDefinition.isAutowireCandidate());
        targetDefinition.setAutowireCandidate(false);
        registry.registerBeanDefinition(targetBeanName, targetDefinition);
        return new BeanDefinitionHolder(scopedProxyDefinition, originalBeanName, definition.getAliases());
    }
}

