/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.aop.support.annotation;

import com.bea.core.repackaged.springframework.aop.ClassFilter;
import com.bea.core.repackaged.springframework.core.annotation.AnnotationUtils;
import com.bea.core.repackaged.springframework.util.Assert;
import java.lang.annotation.Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationClassFilter
implements ClassFilter {
    private final Class<? extends Annotation> annotationType;
    private final boolean checkInherited;

    public AnnotationClassFilter(Class<? extends Annotation> annotationType) {
        this(annotationType, false);
    }

    public AnnotationClassFilter(Class<? extends Annotation> annotationType, boolean checkInherited) {
        Assert.notNull(annotationType, "Annotation type must not be null");
        this.annotationType = annotationType;
        this.checkInherited = checkInherited;
    }

    @Override
    public boolean matches(Class clazz) {
        return this.checkInherited ? AnnotationUtils.findAnnotation(clazz, this.annotationType) != null : clazz.isAnnotationPresent(this.annotationType);
    }
}

