/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.aop.target;

import com.bea.core.repackaged.springframework.aop.target.AbstractBeanFactoryBasedTargetSource;
import com.bea.core.repackaged.springframework.beans.BeansException;
import com.bea.core.repackaged.springframework.beans.factory.BeanDefinitionStoreException;
import com.bea.core.repackaged.springframework.beans.factory.BeanFactory;
import com.bea.core.repackaged.springframework.beans.factory.DisposableBean;
import com.bea.core.repackaged.springframework.beans.factory.config.ConfigurableBeanFactory;

public abstract class AbstractPrototypeBasedTargetSource
extends AbstractBeanFactoryBasedTargetSource {
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        super.setBeanFactory(beanFactory);
        if (!beanFactory.isPrototype(this.getTargetBeanName())) {
            throw new BeanDefinitionStoreException("Cannot use prototype-based TargetSource against non-prototype bean with name '" + this.getTargetBeanName() + "': instances would not be independent");
        }
    }

    protected Object newPrototypeInstance() throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating new instance of bean '" + this.getTargetBeanName() + "'"));
        }
        return this.getBeanFactory().getBean(this.getTargetBeanName());
    }

    protected void destroyPrototypeInstance(Object target) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Destroying instance of bean '" + this.getTargetBeanName() + "'"));
        }
        if (this.getBeanFactory() instanceof ConfigurableBeanFactory) {
            ((ConfigurableBeanFactory)this.getBeanFactory()).destroyBean(this.getTargetBeanName(), target);
        } else if (target instanceof DisposableBean) {
            try {
                ((DisposableBean)target).destroy();
            }
            catch (Throwable ex) {
                this.logger.error((Object)("Couldn't invoke destroy method of bean with name '" + this.getTargetBeanName() + "'"), ex);
            }
        }
    }
}

