/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.aop.target;

import com.bea.core.repackaged.springframework.aop.IntroductionAdvisor;
import com.bea.core.repackaged.springframework.aop.support.DefaultIntroductionAdvisor;
import com.bea.core.repackaged.springframework.aop.support.DelegatingIntroductionInterceptor;
import com.bea.core.repackaged.springframework.aop.target.AbstractPrototypeBasedTargetSource;
import com.bea.core.repackaged.springframework.aop.target.ThreadLocalTargetSourceStats;
import com.bea.core.repackaged.springframework.beans.BeansException;
import com.bea.core.repackaged.springframework.beans.factory.DisposableBean;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ThreadLocalTargetSource
extends AbstractPrototypeBasedTargetSource
implements ThreadLocalTargetSourceStats,
DisposableBean {
    private final ThreadLocal targetInThread = new ThreadLocal(){

        public String toString() {
            return "Thread-local instance of bean '" + ThreadLocalTargetSource.this.getTargetBeanName() + "'";
        }
    };
    private final Set targetSet = Collections.synchronizedSet(new HashSet());
    private int invocationCount;
    private int hitCount;

    public Object getTarget() throws BeansException {
        ++this.invocationCount;
        Object target = this.targetInThread.get();
        if (target == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No target for prototype '" + this.getTargetBeanName() + "' bound to thread: " + "creating one and binding it to thread '" + Thread.currentThread().getName() + "'"));
            }
            target = this.newPrototypeInstance();
            this.targetInThread.set(target);
            this.targetSet.add(target);
        } else {
            ++this.hitCount;
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.logger.debug((Object)"Destroying ThreadLocalTargetSource bindings");
        Set set = this.targetSet;
        synchronized (set) {
            Iterator it = this.targetSet.iterator();
            while (it.hasNext()) {
                this.destroyPrototypeInstance(it.next());
            }
            this.targetSet.clear();
        }
        this.targetInThread.set(null);
    }

    public int getInvocationCount() {
        return this.invocationCount;
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public int getObjectCount() {
        return this.targetSet.size();
    }

    public IntroductionAdvisor getStatsMixin() {
        DelegatingIntroductionInterceptor dii = new DelegatingIntroductionInterceptor(this);
        return new DefaultIntroductionAdvisor(dii, ThreadLocalTargetSourceStats.class);
    }
}

