/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.beans;

import com.bea.core.repackaged.springframework.core.BridgeMethodResolver;
import com.bea.core.repackaged.springframework.core.GenericTypeResolver;
import com.bea.core.repackaged.springframework.core.MethodParameter;
import com.bea.core.repackaged.springframework.util.ClassUtils;
import com.bea.core.repackaged.springframework.util.StringUtils;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;

class GenericTypeAwarePropertyDescriptor
extends PropertyDescriptor {
    private final Class beanClass;
    private final Method readMethod;
    private final Method writeMethod;
    private final Class propertyEditorClass;
    private Class propertyType;
    private MethodParameter writeMethodParameter;

    public GenericTypeAwarePropertyDescriptor(Class clazz, String string, Method method, Method method2, Class clazz2) throws IntrospectionException {
        super(string, null, null);
        this.beanClass = clazz;
        Method method3 = BridgeMethodResolver.findBridgedMethod(method);
        Method method4 = BridgeMethodResolver.findBridgedMethod(method2);
        if (method4 == null && method3 != null) {
            method4 = ClassUtils.getMethodIfAvailable(this.beanClass, "set" + StringUtils.capitalize(this.getName()), new Class[]{method3.getReturnType()});
        }
        this.readMethod = method3;
        this.writeMethod = method4;
        this.propertyEditorClass = clazz2;
    }

    @Override
    public Method getReadMethod() {
        return this.readMethod;
    }

    @Override
    public Method getWriteMethod() {
        return this.writeMethod;
    }

    public Class getPropertyEditorClass() {
        return this.propertyEditorClass;
    }

    public synchronized Class getPropertyType() {
        if (this.propertyType == null) {
            MethodParameter methodParameter;
            this.propertyType = this.readMethod != null ? GenericTypeResolver.resolveReturnType(this.readMethod, this.beanClass) : ((methodParameter = this.getWriteMethodParameter()) != null ? methodParameter.getParameterType() : super.getPropertyType());
        }
        return this.propertyType;
    }

    public synchronized MethodParameter getWriteMethodParameter() {
        if (this.writeMethod == null) {
            return null;
        }
        if (this.writeMethodParameter == null) {
            this.writeMethodParameter = new MethodParameter(this.writeMethod, 0);
            GenericTypeResolver.resolveParameterType(this.writeMethodParameter, this.beanClass);
        }
        return this.writeMethodParameter;
    }
}

