/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.beans.annotation;

import com.bea.core.repackaged.springframework.beans.BeanWrapper;
import com.bea.core.repackaged.springframework.beans.PropertyAccessorFactory;
import com.bea.core.repackaged.springframework.util.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;

public abstract class AnnotationBeanUtils {
    public static void copyPropertiesToBean(Annotation ann, Object bean, String ... excludedProperties) {
        HashSet<String> excluded = new HashSet<String>(Arrays.asList(excludedProperties));
        Method[] annotationProperties = ann.annotationType().getDeclaredMethods();
        BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess(bean);
        for (Method annotationProperty : annotationProperties) {
            String propertyName = annotationProperty.getName();
            if (excluded.contains(propertyName) || !bw.isWritableProperty(propertyName)) continue;
            Object value = ReflectionUtils.invokeMethod(annotationProperty, ann);
            bw.setPropertyValue(propertyName, value);
        }
    }
}

