/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.beans.factory.annotation;

import com.bea.core.repackaged.springframework.beans.SimpleTypeConverter;
import com.bea.core.repackaged.springframework.beans.factory.annotation.Qualifier;
import com.bea.core.repackaged.springframework.beans.factory.config.BeanDefinitionHolder;
import com.bea.core.repackaged.springframework.beans.factory.config.DependencyDescriptor;
import com.bea.core.repackaged.springframework.beans.factory.support.AbstractBeanDefinition;
import com.bea.core.repackaged.springframework.beans.factory.support.AutowireCandidateQualifier;
import com.bea.core.repackaged.springframework.beans.factory.support.AutowireCandidateResolver;
import com.bea.core.repackaged.springframework.core.annotation.AnnotationUtils;
import com.bea.core.repackaged.springframework.util.Assert;
import com.bea.core.repackaged.springframework.util.ClassUtils;
import com.bea.core.repackaged.springframework.util.ObjectUtils;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QualifierAnnotationAutowireCandidateResolver
implements AutowireCandidateResolver {
    private final Set<Class<? extends Annotation>> qualifierTypes;

    public QualifierAnnotationAutowireCandidateResolver() {
        this.qualifierTypes = new HashSet<Class<? extends Annotation>>(1);
        this.qualifierTypes.add(Qualifier.class);
    }

    public QualifierAnnotationAutowireCandidateResolver(Class<? extends Annotation> qualifierType) {
        Assert.notNull(qualifierType, "'qualifierType' must not be null");
        this.qualifierTypes = new HashSet<Class<? extends Annotation>>(1);
        this.qualifierTypes.add(qualifierType);
    }

    public QualifierAnnotationAutowireCandidateResolver(Set<Class<? extends Annotation>> qualifierTypes) {
        Assert.notNull(qualifierTypes, "'qualifierTypes' must not be null");
        this.qualifierTypes = new HashSet<Class<? extends Annotation>>(qualifierTypes);
    }

    public void addQualifierType(Class<? extends Annotation> qualifierType) {
        this.qualifierTypes.add(qualifierType);
    }

    @Override
    public boolean isAutowireCandidate(BeanDefinitionHolder bdHolder, DependencyDescriptor descriptor) {
        Annotation[] annotations;
        if (!bdHolder.getBeanDefinition().isAutowireCandidate()) {
            return false;
        }
        if (descriptor == null || ObjectUtils.isEmpty(descriptor.getAnnotations())) {
            return true;
        }
        AbstractBeanDefinition bd = (AbstractBeanDefinition)bdHolder.getBeanDefinition();
        SimpleTypeConverter typeConverter = new SimpleTypeConverter();
        for (Annotation annotation : annotations = (Annotation[])descriptor.getAnnotations()) {
            Class beanClass;
            Annotation targetAnnotation;
            Class<? extends Annotation> type = annotation.annotationType();
            if (!this.isQualifier(type)) continue;
            AutowireCandidateQualifier qualifier = bd.getQualifier(type.getName());
            if (qualifier == null) {
                qualifier = bd.getQualifier(ClassUtils.getShortName(type));
            }
            if (qualifier == null && bd.hasBeanClass() && (targetAnnotation = (beanClass = bd.getBeanClass()).getAnnotation(type)) != null && ((Object)targetAnnotation).equals(annotation)) {
                return true;
            }
            Map<String, Object> attributes = AnnotationUtils.getAnnotationAttributes(annotation);
            if (attributes.isEmpty() && qualifier == null) {
                return false;
            }
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                String attributeName = entry.getKey();
                Object expectedValue = entry.getValue();
                Object actualValue = null;
                if (qualifier != null) {
                    actualValue = qualifier.getAttribute(attributeName);
                }
                if (actualValue == null) {
                    actualValue = bd.getAttribute(attributeName);
                }
                if (actualValue == null && attributeName.equals(AutowireCandidateQualifier.VALUE_KEY) && (expectedValue.equals(bdHolder.getBeanName()) || ObjectUtils.containsElement(bdHolder.getAliases(), expectedValue))) continue;
                if (actualValue == null && qualifier != null) {
                    actualValue = AnnotationUtils.getDefaultValue(annotation, attributeName);
                }
                if (actualValue != null) {
                    actualValue = typeConverter.convertIfNecessary(actualValue, expectedValue.getClass());
                }
                if (expectedValue.equals(actualValue)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isQualifier(Class<? extends Annotation> annotationType) {
        for (Class<? extends Annotation> qualifierType : this.qualifierTypes) {
            if (!annotationType.equals(qualifierType) && !annotationType.isAnnotationPresent(qualifierType)) continue;
            return true;
        }
        return false;
    }
}

