/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.beans.factory.annotation;

import com.bea.core.repackaged.springframework.beans.BeansException;
import com.bea.core.repackaged.springframework.beans.PropertyValues;
import com.bea.core.repackaged.springframework.beans.factory.BeanInitializationException;
import com.bea.core.repackaged.springframework.beans.factory.annotation.Required;
import com.bea.core.repackaged.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import com.bea.core.repackaged.springframework.core.PriorityOrdered;
import com.bea.core.repackaged.springframework.core.annotation.AnnotationUtils;
import com.bea.core.repackaged.springframework.util.Assert;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequiredAnnotationBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements PriorityOrdered {
    private Class<? extends Annotation> requiredAnnotationType = Required.class;
    private int order = 0x7FFFFFFE;
    private final Set<String> validatedBeanNames = Collections.synchronizedSet(new HashSet());

    public void setRequiredAnnotationType(Class<? extends Annotation> requiredAnnotationType) {
        Assert.notNull(requiredAnnotationType, "'requiredAnnotationType' must not be null");
        this.requiredAnnotationType = requiredAnnotationType;
    }

    protected Class<? extends Annotation> getRequiredAnnotationType() {
        return this.requiredAnnotationType;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeansException {
        if (!this.validatedBeanNames.contains(beanName)) {
            ArrayList<String> invalidProperties = new ArrayList<String>();
            for (PropertyDescriptor pd : pds) {
                if (!this.isRequiredProperty(pd) || pvs.contains(pd.getName())) continue;
                invalidProperties.add(pd.getName());
            }
            if (!invalidProperties.isEmpty()) {
                throw new BeanInitializationException(this.buildExceptionMessage(invalidProperties, beanName));
            }
            this.validatedBeanNames.add(beanName);
        }
        return pvs;
    }

    protected boolean isRequiredProperty(PropertyDescriptor propertyDescriptor) {
        Method setter = propertyDescriptor.getWriteMethod();
        return setter != null && AnnotationUtils.getAnnotation(setter, this.getRequiredAnnotationType()) != null;
    }

    private String buildExceptionMessage(List<String> invalidProperties, String beanName) {
        int size = invalidProperties.size();
        StringBuilder sb = new StringBuilder();
        sb.append(size == 1 ? "Property" : "Properties");
        for (int i = 0; i < size; ++i) {
            String propertyName = invalidProperties.get(i);
            if (i > 0) {
                if (i == size - 1) {
                    sb.append(" and");
                } else {
                    sb.append(",");
                }
            }
            sb.append(" '").append(propertyName).append("'");
        }
        sb.append(size == 1 ? " is" : " are");
        sb.append(" required for bean '").append(beanName).append("'");
        return sb.toString();
    }
}

