/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.beans.factory.config;

import com.bea.core.repackaged.springframework.core.GenericCollectionTypeResolver;
import com.bea.core.repackaged.springframework.core.JdkVersion;
import com.bea.core.repackaged.springframework.core.MethodParameter;
import com.bea.core.repackaged.springframework.util.Assert;
import com.bea.core.repackaged.springframework.util.ClassUtils;
import com.bea.core.repackaged.springframework.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class DependencyDescriptor {
    private static final Method fieldAnnotationsMethod = ClassUtils.getMethodIfAvailable(Field.class, "getAnnotations", new Class[0]);
    private MethodParameter methodParameter;
    private Field field;
    private final boolean required;
    private final boolean eager;
    private Object[] fieldAnnotations;

    public DependencyDescriptor(MethodParameter methodParameter, boolean required) {
        this(methodParameter, required, true);
    }

    public DependencyDescriptor(MethodParameter methodParameter, boolean required, boolean eager) {
        Assert.notNull(methodParameter, "MethodParameter must not be null");
        this.methodParameter = methodParameter;
        this.required = required;
        this.eager = eager;
    }

    public DependencyDescriptor(Field field, boolean required) {
        this(field, required, true);
    }

    public DependencyDescriptor(Field field, boolean required, boolean eager) {
        Assert.notNull(field, "Field must not be null");
        this.field = field;
        this.required = required;
        this.eager = eager;
    }

    public MethodParameter getMethodParameter() {
        return this.methodParameter;
    }

    public Field getField() {
        return this.field;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isEager() {
        return this.eager;
    }

    public Class getDependencyType() {
        return this.field != null ? this.field.getType() : this.methodParameter.getParameterType();
    }

    public Class getCollectionType() {
        if (JdkVersion.getMajorJavaVersion() < 2) {
            return null;
        }
        return this.field != null ? GenericCollectionTypeResolver.getCollectionFieldType(this.field) : GenericCollectionTypeResolver.getCollectionParameterType(this.methodParameter);
    }

    public Class getMapKeyType() {
        if (JdkVersion.getMajorJavaVersion() < 2) {
            return null;
        }
        return this.field != null ? GenericCollectionTypeResolver.getMapKeyFieldType(this.field) : GenericCollectionTypeResolver.getMapKeyParameterType(this.methodParameter);
    }

    public Class getMapValueType() {
        if (JdkVersion.getMajorJavaVersion() < 2) {
            return null;
        }
        return this.field != null ? GenericCollectionTypeResolver.getMapValueFieldType(this.field) : GenericCollectionTypeResolver.getMapValueParameterType(this.methodParameter);
    }

    public Object[] getAnnotations() {
        if (this.field != null) {
            if (this.fieldAnnotations != null) {
                return this.fieldAnnotations;
            }
            if (fieldAnnotationsMethod == null) {
                return null;
            }
            this.fieldAnnotations = (Object[])ReflectionUtils.invokeMethod(fieldAnnotationsMethod, this.field);
            return this.fieldAnnotations;
        }
        return this.methodParameter.getParameterAnnotations();
    }
}

