/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.beans.factory.config;

import com.bea.core.repackaged.springframework.beans.TypeConverter;
import com.bea.core.repackaged.springframework.beans.factory.BeanClassLoaderAware;
import com.bea.core.repackaged.springframework.beans.factory.BeanFactory;
import com.bea.core.repackaged.springframework.beans.factory.BeanFactoryAware;
import com.bea.core.repackaged.springframework.beans.factory.FactoryBean;
import com.bea.core.repackaged.springframework.beans.factory.FactoryBeanNotInitializedException;
import com.bea.core.repackaged.springframework.beans.factory.InitializingBean;
import com.bea.core.repackaged.springframework.beans.factory.config.ConfigurableBeanFactory;
import com.bea.core.repackaged.springframework.beans.support.ArgumentConvertingMethodInvoker;
import com.bea.core.repackaged.springframework.util.ClassUtils;
import java.lang.reflect.InvocationTargetException;

public class MethodInvokingFactoryBean
extends ArgumentConvertingMethodInvoker
implements FactoryBean,
BeanClassLoaderAware,
BeanFactoryAware,
InitializingBean {
    private boolean singleton = true;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private ConfigurableBeanFactory beanFactory;
    private boolean initialized = false;
    private Object singletonObject;

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    protected Class resolveClassName(String className) throws ClassNotFoundException {
        return ClassUtils.forName(className, this.beanClassLoader);
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory instanceof ConfigurableBeanFactory) {
            this.beanFactory = (ConfigurableBeanFactory)beanFactory;
        }
    }

    protected TypeConverter getDefaultTypeConverter() {
        if (this.beanFactory != null) {
            return this.beanFactory.getTypeConverter();
        }
        return super.getDefaultTypeConverter();
    }

    public void afterPropertiesSet() throws Exception {
        this.prepare();
        if (this.singleton) {
            this.initialized = true;
            this.singletonObject = this.doInvoke();
        }
    }

    private Object doInvoke() throws Exception {
        try {
            return this.invoke();
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof Exception) {
                throw (Exception)ex.getTargetException();
            }
            if (ex.getTargetException() instanceof Error) {
                throw (Error)ex.getTargetException();
            }
            throw ex;
        }
    }

    public Object getObject() throws Exception {
        if (this.singleton) {
            if (!this.initialized) {
                throw new FactoryBeanNotInitializedException();
            }
            return this.singletonObject;
        }
        return this.doInvoke();
    }

    public Class getObjectType() {
        if (!this.isPrepared()) {
            return null;
        }
        return this.getPreparedMethod().getReturnType();
    }
}

