/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.beans.factory.config;

import com.bea.core.repackaged.springframework.beans.BeanUtils;
import com.bea.core.repackaged.springframework.beans.TypeConverter;
import com.bea.core.repackaged.springframework.beans.factory.config.AbstractFactoryBean;
import com.bea.core.repackaged.springframework.core.GenericCollectionTypeResolver;
import com.bea.core.repackaged.springframework.core.JdkVersion;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class SetFactoryBean
extends AbstractFactoryBean {
    private Set sourceSet;
    private Class targetSetClass;

    public void setSourceSet(Set sourceSet) {
        this.sourceSet = sourceSet;
    }

    public void setTargetSetClass(Class targetSetClass) {
        if (targetSetClass == null) {
            throw new IllegalArgumentException("'targetSetClass' must not be null");
        }
        if (!Set.class.isAssignableFrom(targetSetClass)) {
            throw new IllegalArgumentException("'targetSetClass' must implement [java.util.Set]");
        }
        this.targetSetClass = targetSetClass;
    }

    public Class getObjectType() {
        return Set.class;
    }

    protected Object createInstance() {
        if (this.sourceSet == null) {
            throw new IllegalArgumentException("'sourceSet' is required");
        }
        LinkedHashSet<Object> result = null;
        result = this.targetSetClass != null ? (LinkedHashSet<Object>)BeanUtils.instantiateClass(this.targetSetClass) : new LinkedHashSet<Object>(this.sourceSet.size());
        Class valueType = null;
        if (this.targetSetClass != null && JdkVersion.isAtLeastJava15()) {
            valueType = GenericCollectionTypeResolver.getCollectionType(this.targetSetClass);
        }
        if (valueType != null) {
            TypeConverter converter = this.getBeanTypeConverter();
            Iterator it = this.sourceSet.iterator();
            while (it.hasNext()) {
                result.add(converter.convertIfNecessary(it.next(), valueType));
            }
        } else {
            result.addAll(this.sourceSet);
        }
        return result;
    }
}

