/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.beans.factory.config;

import com.bea.core.repackaged.springframework.beans.BeanMetadataElement;
import com.bea.core.repackaged.springframework.util.Assert;
import com.bea.core.repackaged.springframework.util.ClassUtils;
import com.bea.core.repackaged.springframework.util.ObjectUtils;

public class TypedStringValue
implements BeanMetadataElement {
    private String value;
    private Object targetType;
    private Object source;

    public TypedStringValue(String value) {
        this.setValue(value);
    }

    public TypedStringValue(String value, Class targetType) {
        this.setValue(value);
        this.setTargetType(targetType);
    }

    public TypedStringValue(String value, String targetTypeName) {
        this.setValue(value);
        this.setTargetTypeName(targetTypeName);
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setTargetType(Class targetType) {
        Assert.notNull(targetType, "'targetType' must not be null");
        this.targetType = targetType;
    }

    public Class getTargetType() {
        if (!(this.targetType instanceof Class)) {
            throw new IllegalStateException("Typed String value does not carry a resolved target type");
        }
        return (Class)this.targetType;
    }

    public void setTargetTypeName(String targetTypeName) {
        Assert.notNull(targetTypeName, "'targetTypeName' must not be null");
        this.targetType = targetTypeName;
    }

    public String getTargetTypeName() {
        if (this.targetType instanceof Class) {
            return ((Class)this.targetType).getName();
        }
        return (String)this.targetType;
    }

    public boolean hasTargetType() {
        return this.targetType instanceof Class;
    }

    public Class resolveTargetType(ClassLoader classLoader) throws ClassNotFoundException {
        if (this.targetType == null) {
            return null;
        }
        Class resolvedClass = ClassUtils.forName(this.getTargetTypeName(), classLoader);
        this.targetType = resolvedClass;
        return resolvedClass;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public Object getSource() {
        return this.source;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TypedStringValue)) {
            return false;
        }
        TypedStringValue otherValue = (TypedStringValue)other;
        return ObjectUtils.nullSafeEquals(this.value, otherValue.value) && ObjectUtils.nullSafeEquals(this.targetType, otherValue.targetType);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.value) * 29 + ObjectUtils.nullSafeHashCode(this.targetType);
    }

    public String toString() {
        return "TypedStringValue: value [" + this.value + "], target type [" + this.targetType + "]";
    }
}

