/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.beans.factory.support;

import com.bea.core.repackaged.apache.commons.logging.Log;
import com.bea.core.repackaged.apache.commons.logging.LogFactory;
import com.bea.core.repackaged.springframework.beans.factory.BeanDefinitionStoreException;
import com.bea.core.repackaged.springframework.beans.factory.support.BeanDefinitionReader;
import com.bea.core.repackaged.springframework.beans.factory.support.BeanDefinitionRegistry;
import com.bea.core.repackaged.springframework.beans.factory.support.BeanNameGenerator;
import com.bea.core.repackaged.springframework.beans.factory.support.DefaultBeanNameGenerator;
import com.bea.core.repackaged.springframework.core.io.Resource;
import com.bea.core.repackaged.springframework.core.io.ResourceLoader;
import com.bea.core.repackaged.springframework.core.io.support.PathMatchingResourcePatternResolver;
import com.bea.core.repackaged.springframework.core.io.support.ResourcePatternResolver;
import com.bea.core.repackaged.springframework.util.Assert;
import java.io.IOException;
import java.util.Set;

public abstract class AbstractBeanDefinitionReader
implements BeanDefinitionReader {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final BeanDefinitionRegistry registry;
    private ResourceLoader resourceLoader;
    private ClassLoader beanClassLoader;
    private BeanNameGenerator beanNameGenerator = new DefaultBeanNameGenerator();

    protected AbstractBeanDefinitionReader(BeanDefinitionRegistry registry) {
        Assert.notNull(registry, "BeanDefinitionRegistry must not be null");
        this.registry = registry;
        this.resourceLoader = this.registry instanceof ResourceLoader ? (ResourceLoader)((Object)this.registry) : new PathMatchingResourcePatternResolver();
    }

    public final BeanDefinitionRegistry getBeanFactory() {
        return this.registry;
    }

    public final BeanDefinitionRegistry getRegistry() {
        return this.registry;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    public ClassLoader getBeanClassLoader() {
        return this.beanClassLoader;
    }

    public void setBeanNameGenerator(BeanNameGenerator beanNameGenerator) {
        this.beanNameGenerator = beanNameGenerator != null ? beanNameGenerator : new DefaultBeanNameGenerator();
    }

    public BeanNameGenerator getBeanNameGenerator() {
        return this.beanNameGenerator;
    }

    public int loadBeanDefinitions(Resource[] resources) throws BeanDefinitionStoreException {
        Assert.notNull(resources, "Resource array must not be null");
        int counter = 0;
        for (int i = 0; i < resources.length; ++i) {
            counter += this.loadBeanDefinitions(resources[i]);
        }
        return counter;
    }

    public int loadBeanDefinitions(String location) throws BeanDefinitionStoreException {
        return this.loadBeanDefinitions(location, null);
    }

    public int loadBeanDefinitions(String location, Set actualResources) throws BeanDefinitionStoreException {
        ResourceLoader resourceLoader = this.getResourceLoader();
        if (resourceLoader == null) {
            throw new BeanDefinitionStoreException("Cannot import bean definitions from location [" + location + "]: no ResourceLoader available");
        }
        if (resourceLoader instanceof ResourcePatternResolver) {
            try {
                Resource[] resources = ((ResourcePatternResolver)resourceLoader).getResources(location);
                int loadCount = this.loadBeanDefinitions(resources);
                if (actualResources != null) {
                    for (int i = 0; i < resources.length; ++i) {
                        actualResources.add(resources[i]);
                    }
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Loaded " + loadCount + " bean definitions from location pattern [" + location + "]"));
                }
                return loadCount;
            }
            catch (IOException ex) {
                throw new BeanDefinitionStoreException("Could not resolve bean definition resource pattern [" + location + "]", ex);
            }
        }
        Resource resource = resourceLoader.getResource(location);
        int loadCount = this.loadBeanDefinitions(resource);
        if (actualResources != null) {
            actualResources.add(resource);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Loaded " + loadCount + " bean definitions from location [" + location + "]"));
        }
        return loadCount;
    }

    public int loadBeanDefinitions(String[] locations) throws BeanDefinitionStoreException {
        Assert.notNull(locations, "Location array must not be null");
        int counter = 0;
        for (int i = 0; i < locations.length; ++i) {
            counter += this.loadBeanDefinitions(locations[i]);
        }
        return counter;
    }
}

