/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.beans.factory.support;

import com.bea.core.repackaged.springframework.beans.MutablePropertyValues;
import com.bea.core.repackaged.springframework.beans.factory.config.BeanDefinition;
import com.bea.core.repackaged.springframework.beans.factory.config.ConstructorArgumentValues;
import com.bea.core.repackaged.springframework.beans.factory.support.AbstractBeanDefinition;
import java.lang.reflect.Member;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class RootBeanDefinition
extends AbstractBeanDefinition {
    private final Set externallyManagedConfigMembers = Collections.synchronizedSet(new HashSet());
    private final Set externallyManagedInitMethods = Collections.synchronizedSet(new HashSet());
    private final Set externallyManagedDestroyMethods = Collections.synchronizedSet(new HashSet());
    volatile Object resolvedConstructorOrFactoryMethod;
    volatile Object[] resolvedConstructorArguments;
    volatile Object[] preparedConstructorArguments;
    volatile boolean constructorArgumentsResolved = false;
    volatile Boolean beforeInstantiationResolved;
    volatile boolean postProcessed = false;

    public RootBeanDefinition() {
    }

    public RootBeanDefinition(Class beanClass) {
        this.setBeanClass(beanClass);
    }

    public RootBeanDefinition(Class beanClass, boolean singleton) {
        this.setBeanClass(beanClass);
        this.setSingleton(singleton);
    }

    public RootBeanDefinition(Class beanClass, int autowireMode) {
        this.setBeanClass(beanClass);
        this.setAutowireMode(autowireMode);
    }

    public RootBeanDefinition(Class beanClass, int autowireMode, boolean dependencyCheck) {
        this.setBeanClass(beanClass);
        this.setAutowireMode(autowireMode);
        if (dependencyCheck && this.getResolvedAutowireMode() != 3) {
            this.setDependencyCheck(1);
        }
    }

    public RootBeanDefinition(Class beanClass, MutablePropertyValues pvs) {
        super(null, pvs);
        this.setBeanClass(beanClass);
    }

    public RootBeanDefinition(Class beanClass, MutablePropertyValues pvs, boolean singleton) {
        super(null, pvs);
        this.setBeanClass(beanClass);
        this.setSingleton(singleton);
    }

    public RootBeanDefinition(Class beanClass, ConstructorArgumentValues cargs, MutablePropertyValues pvs) {
        super(cargs, pvs);
        this.setBeanClass(beanClass);
    }

    public RootBeanDefinition(String beanClassName, ConstructorArgumentValues cargs, MutablePropertyValues pvs) {
        super(cargs, pvs);
        this.setBeanClassName(beanClassName);
    }

    public RootBeanDefinition(RootBeanDefinition original) {
        super((BeanDefinition)original);
    }

    RootBeanDefinition(BeanDefinition original) {
        super(original);
    }

    public String getParentName() {
        return null;
    }

    public void setParentName(String parentName) {
        if (parentName != null) {
            throw new IllegalArgumentException("Root bean cannot be changed into a child bean with parent reference");
        }
    }

    public void registerExternallyManagedConfigMember(Member configMember) {
        this.externallyManagedConfigMembers.add(configMember);
    }

    public boolean isExternallyManagedConfigMember(Member configMember) {
        return this.externallyManagedConfigMembers.contains(configMember);
    }

    public void registerExternallyManagedInitMethod(String initMethod) {
        this.externallyManagedInitMethods.add(initMethod);
    }

    public boolean isExternallyManagedInitMethod(String initMethod) {
        return this.externallyManagedInitMethods.contains(initMethod);
    }

    public void registerExternallyManagedDestroyMethod(String destroyMethod) {
        this.externallyManagedDestroyMethods.add(destroyMethod);
    }

    public boolean isExternallyManagedDestroyMethod(String destroyMethod) {
        return this.externallyManagedDestroyMethods.contains(destroyMethod);
    }

    public AbstractBeanDefinition cloneBeanDefinition() {
        return new RootBeanDefinition(this);
    }

    public boolean equals(Object other) {
        return this == other || other instanceof RootBeanDefinition && super.equals(other);
    }

    public String toString() {
        return "Root bean: " + super.toString();
    }
}

