/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.beans.factory.xml;

import com.bea.core.repackaged.apache.commons.logging.Log;
import com.bea.core.repackaged.apache.commons.logging.LogFactory;
import com.bea.core.repackaged.springframework.beans.factory.xml.DocumentLoader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class DefaultDocumentLoader
implements DocumentLoader {
    private static final String SCHEMA_LANGUAGE_ATTRIBUTE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String XSD_SCHEMA_LANGUAGE = "http://www.w3.org/2001/XMLSchema";
    private static final Log logger = LogFactory.getLog(DefaultDocumentLoader.class);

    @Override
    public Document loadDocument(InputSource inputSource, EntityResolver entityResolver, ErrorHandler errorHandler, int n, boolean bl) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = this.createDocumentBuilderFactory(n, bl);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using JAXP provider [" + documentBuilderFactory.getClass().getName() + "]"));
        }
        DocumentBuilder documentBuilder = this.createDocumentBuilder(documentBuilderFactory, entityResolver, errorHandler);
        return documentBuilder.parse(inputSource);
    }

    protected DocumentBuilderFactory createDocumentBuilderFactory(int n, boolean bl) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = null;
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
        }
        catch (Exception exception) {
            documentBuilderFactory = DocumentBuilderFactory.newInstance("com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl", this.getClass().getClassLoader());
        }
        documentBuilderFactory.setNamespaceAware(bl);
        if (n != 0) {
            documentBuilderFactory.setValidating(true);
            if (n == 3) {
                documentBuilderFactory.setNamespaceAware(true);
                try {
                    documentBuilderFactory.setAttribute(SCHEMA_LANGUAGE_ATTRIBUTE, XSD_SCHEMA_LANGUAGE);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ParserConfigurationException parserConfigurationException = new ParserConfigurationException("Unable to validate using XSD: Your JAXP provider [" + documentBuilderFactory + "] does not support XML Schema. Are you running on Java 1.4 with Apache Crimson? " + "Upgrade to Apache Xerces (or Java 1.5) for full XSD support.");
                    parserConfigurationException.initCause(illegalArgumentException);
                    throw parserConfigurationException;
                }
            }
        }
        return documentBuilderFactory;
    }

    protected DocumentBuilder createDocumentBuilder(DocumentBuilderFactory documentBuilderFactory, EntityResolver entityResolver, ErrorHandler errorHandler) throws ParserConfigurationException {
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        if (entityResolver != null) {
            documentBuilder.setEntityResolver(entityResolver);
        }
        if (errorHandler != null) {
            documentBuilder.setErrorHandler(errorHandler);
        }
        return documentBuilder;
    }
}

