/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.beans.factory.xml;

import com.bea.core.repackaged.apache.commons.logging.Log;
import com.bea.core.repackaged.apache.commons.logging.LogFactory;
import com.bea.core.repackaged.springframework.beans.BeanUtils;
import com.bea.core.repackaged.springframework.beans.FatalBeanException;
import com.bea.core.repackaged.springframework.beans.factory.xml.NamespaceHandler;
import com.bea.core.repackaged.springframework.beans.factory.xml.NamespaceHandlerResolver;
import com.bea.core.repackaged.springframework.core.io.support.PropertiesLoaderUtils;
import com.bea.core.repackaged.springframework.util.Assert;
import com.bea.core.repackaged.springframework.util.ClassUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class DefaultNamespaceHandlerResolver
implements NamespaceHandlerResolver {
    public static final String DEFAULT_HANDLER_MAPPINGS_LOCATION = "META-INF/bea-spring.handlers";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final ClassLoader classLoader;
    private final String handlerMappingsLocation;
    private Map handlerMappings;

    public DefaultNamespaceHandlerResolver() {
        this(null, DEFAULT_HANDLER_MAPPINGS_LOCATION);
    }

    public DefaultNamespaceHandlerResolver(ClassLoader classLoader) {
        this(classLoader, DEFAULT_HANDLER_MAPPINGS_LOCATION);
    }

    public DefaultNamespaceHandlerResolver(ClassLoader classLoader, String string) {
        Assert.notNull(string, "Handler mappings location must not be null");
        this.classLoader = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
        this.handlerMappingsLocation = string;
    }

    @Override
    public NamespaceHandler resolve(String string) {
        Map map = this.getHandlerMappings();
        Object v = map.get(string);
        if (v == null) {
            return null;
        }
        if (v instanceof NamespaceHandler) {
            return (NamespaceHandler)v;
        }
        String string2 = (String)v;
        try {
            Class clazz = ClassUtils.forName(string2, this.classLoader);
            if (!NamespaceHandler.class.isAssignableFrom(clazz)) {
                throw new FatalBeanException("Class [" + string2 + "] for namespace [" + string + "] does not implement the [" + NamespaceHandler.class.getName() + "] interface");
            }
            NamespaceHandler namespaceHandler = (NamespaceHandler)BeanUtils.instantiateClass(clazz);
            namespaceHandler.init();
            map.put(string, namespaceHandler);
            return namespaceHandler;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new FatalBeanException("NamespaceHandler class [" + string2 + "] for namespace [" + string + "] not found", classNotFoundException);
        }
        catch (LinkageError linkageError) {
            throw new FatalBeanException("Invalid NamespaceHandler class [" + string2 + "] for namespace [" + string + "]: problem with handler class file or dependent class", linkageError);
        }
    }

    private Map getHandlerMappings() {
        if (this.handlerMappings == null) {
            try {
                Properties properties = PropertiesLoaderUtils.loadAllProperties(this.handlerMappingsLocation, this.classLoader);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Loaded mappings [" + properties + "]"));
                }
                this.handlerMappings = new HashMap<Object, Object>(properties);
            }
            catch (IOException iOException) {
                IllegalStateException illegalStateException = new IllegalStateException("Unable to load NamespaceHandler mappings from location [" + this.handlerMappingsLocation + "]");
                illegalStateException.initCause(iOException);
                throw illegalStateException;
            }
        }
        return this.handlerMappings;
    }
}

