/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class CustomMapEditor
extends PropertyEditorSupport {
    private final Class mapType;
    private final boolean nullAsEmptyMap;

    public CustomMapEditor(Class mapType) {
        this(mapType, false);
    }

    public CustomMapEditor(Class mapType, boolean nullAsEmptyMap) {
        if (mapType == null) {
            throw new IllegalArgumentException("Map type is required");
        }
        if (!Map.class.isAssignableFrom(mapType)) {
            throw new IllegalArgumentException("Map type [" + mapType.getName() + "] does not implement [java.util.Map]");
        }
        this.mapType = mapType;
        this.nullAsEmptyMap = nullAsEmptyMap;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(text);
    }

    public void setValue(Object value) {
        if (value == null && this.nullAsEmptyMap) {
            super.setValue(this.createMap(this.mapType, 0));
        } else if (value == null || this.mapType.isInstance(value) && !this.alwaysCreateNewMap()) {
            super.setValue(value);
        } else if (value instanceof Map) {
            Map source = (Map)value;
            Map target = this.createMap(this.mapType, source.size());
            Iterator it = source.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                target.put(this.convertKey(entry.getKey()), this.convertValue(entry.getValue()));
            }
            super.setValue(target);
        } else {
            throw new IllegalArgumentException("Value cannot be converted to Map: " + value);
        }
    }

    protected Map createMap(Class mapType, int initialCapacity) {
        if (!mapType.isInterface()) {
            try {
                return (Map)mapType.newInstance();
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Could not instantiate map class [" + mapType.getName() + "]: " + ex.getMessage());
            }
        }
        if (SortedMap.class.equals(mapType)) {
            return new TreeMap();
        }
        return new LinkedHashMap(initialCapacity);
    }

    protected boolean alwaysCreateNewMap() {
        return false;
    }

    protected Object convertKey(Object key) {
        return key;
    }

    protected Object convertValue(Object value) {
        return value;
    }

    public String getAsText() {
        return null;
    }
}

