/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.beans.support;

import [Lcom.bea.core.repackaged.springframework.core.io.Resource;;
import com.bea.core.repackaged.springframework.beans.PropertyEditorRegistrar;
import com.bea.core.repackaged.springframework.beans.PropertyEditorRegistry;
import com.bea.core.repackaged.springframework.beans.propertyeditors.ClassEditor;
import com.bea.core.repackaged.springframework.beans.propertyeditors.FileEditor;
import com.bea.core.repackaged.springframework.beans.propertyeditors.InputStreamEditor;
import com.bea.core.repackaged.springframework.beans.propertyeditors.URIEditor;
import com.bea.core.repackaged.springframework.beans.propertyeditors.URLEditor;
import com.bea.core.repackaged.springframework.core.io.Resource;
import com.bea.core.repackaged.springframework.core.io.ResourceEditor;
import com.bea.core.repackaged.springframework.core.io.ResourceLoader;
import com.bea.core.repackaged.springframework.core.io.support.ResourceArrayPropertyEditor;
import com.bea.core.repackaged.springframework.core.io.support.ResourcePatternResolver;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;

public class ResourceEditorRegistrar
implements PropertyEditorRegistrar {
    private final ResourceLoader resourceLoader;

    public ResourceEditorRegistrar(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void registerCustomEditors(PropertyEditorRegistry registry) {
        ResourceEditor baseEditor = new ResourceEditor(this.resourceLoader);
        registry.registerCustomEditor(Resource.class, baseEditor);
        registry.registerCustomEditor(InputStream.class, new InputStreamEditor(baseEditor));
        registry.registerCustomEditor(File.class, new FileEditor(baseEditor));
        registry.registerCustomEditor(URL.class, new URLEditor(baseEditor));
        ClassLoader classLoader = this.resourceLoader.getClassLoader();
        registry.registerCustomEditor(Class.class, new ClassEditor(classLoader));
        registry.registerCustomEditor(URI.class, new URIEditor(classLoader));
        if (this.resourceLoader instanceof ResourcePatternResolver) {
            registry.registerCustomEditor(Resource;.class, new ResourceArrayPropertyEditor((ResourcePatternResolver)this.resourceLoader));
        }
    }
}

