/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.context.access;

import com.bea.core.repackaged.springframework.beans.factory.BeanFactory;
import com.bea.core.repackaged.springframework.beans.factory.access.BeanFactoryReference;
import com.bea.core.repackaged.springframework.context.ApplicationContext;
import com.bea.core.repackaged.springframework.context.ConfigurableApplicationContext;

public class ContextBeanFactoryReference
implements BeanFactoryReference {
    private ApplicationContext applicationContext;

    public ContextBeanFactoryReference(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public BeanFactory getFactory() {
        if (this.applicationContext == null) {
            throw new IllegalStateException("ApplicationContext owned by this BeanFactoryReference has been released");
        }
        return this.applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (this.applicationContext != null) {
            ApplicationContext savedCtx;
            ContextBeanFactoryReference contextBeanFactoryReference = this;
            synchronized (contextBeanFactoryReference) {
                savedCtx = this.applicationContext;
                this.applicationContext = null;
            }
            if (savedCtx != null && savedCtx instanceof ConfigurableApplicationContext) {
                ((ConfigurableApplicationContext)savedCtx).close();
            }
        }
    }
}

