/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.context.access;

import com.bea.core.repackaged.springframework.beans.BeansException;
import com.bea.core.repackaged.springframework.beans.factory.BeanFactory;
import com.bea.core.repackaged.springframework.beans.factory.access.BeanFactoryLocator;
import com.bea.core.repackaged.springframework.beans.factory.access.SingletonBeanFactoryLocator;
import com.bea.core.repackaged.springframework.context.ConfigurableApplicationContext;
import com.bea.core.repackaged.springframework.context.support.ClassPathXmlApplicationContext;
import com.bea.core.repackaged.springframework.core.io.support.ResourcePatternUtils;
import java.util.HashMap;
import java.util.Map;

public class ContextSingletonBeanFactoryLocator
extends SingletonBeanFactoryLocator {
    private static final String DEFAULT_RESOURCE_LOCATION = "classpath*:beanRefContext.xml";
    private static final Map instances = new HashMap();

    public static BeanFactoryLocator getInstance() throws BeansException {
        return ContextSingletonBeanFactoryLocator.getInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BeanFactoryLocator getInstance(String selector) throws BeansException {
        String resourceLocation = selector;
        if (resourceLocation == null) {
            resourceLocation = DEFAULT_RESOURCE_LOCATION;
        }
        if (!ResourcePatternUtils.isUrl(resourceLocation)) {
            resourceLocation = "classpath*:" + resourceLocation;
        }
        Map map = instances;
        synchronized (map) {
            BeanFactoryLocator bfl;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("ContextSingletonBeanFactoryLocator.getInstance(): instances.hashCode=" + ((Object)instances).hashCode() + ", instances=" + instances));
            }
            if ((bfl = (BeanFactoryLocator)instances.get(resourceLocation)) == null) {
                bfl = new ContextSingletonBeanFactoryLocator(resourceLocation);
                instances.put(resourceLocation, bfl);
            }
            return bfl;
        }
    }

    protected ContextSingletonBeanFactoryLocator(String resourceLocation) {
        super(resourceLocation);
    }

    protected BeanFactory createDefinition(String resourceLocation, String factoryKey) {
        return new ClassPathXmlApplicationContext(new String[]{resourceLocation}, false);
    }

    protected void initializeDefinition(BeanFactory groupDef) {
        if (groupDef instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)groupDef).refresh();
        }
    }

    protected void destroyDefinition(BeanFactory groupDef, String selector) {
        if (groupDef instanceof ConfigurableApplicationContext) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Context group with selector '" + selector + "' being released, as there are no more references to it"));
            }
            ((ConfigurableApplicationContext)groupDef).close();
        }
    }
}

