/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.context.event;

import com.bea.core.repackaged.springframework.beans.BeanUtils;
import com.bea.core.repackaged.springframework.context.ApplicationListener;
import com.bea.core.repackaged.springframework.context.event.ApplicationEventMulticaster;
import com.bea.core.repackaged.springframework.core.CollectionFactory;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class AbstractApplicationEventMulticaster
implements ApplicationEventMulticaster {
    private Collection applicationListeners = new LinkedHashSet();

    public void setConcurrentUpdates(boolean concurrent) {
        Set newColl = concurrent ? CollectionFactory.createCopyOnWriteSet() : new LinkedHashSet();
        newColl.addAll(this.applicationListeners);
        this.applicationListeners = newColl;
    }

    public void setCollectionClass(Class collectionClass) {
        if (collectionClass == null) {
            throw new IllegalArgumentException("'collectionClass' must not be null");
        }
        if (!Collection.class.isAssignableFrom(collectionClass)) {
            throw new IllegalArgumentException("'collectionClass' must implement [java.util.Collection]");
        }
        Collection newColl = (Collection)BeanUtils.instantiateClass(collectionClass);
        newColl.addAll(this.applicationListeners);
        this.applicationListeners = newColl;
    }

    public void addApplicationListener(ApplicationListener listener) {
        this.applicationListeners.add(listener);
    }

    public void removeApplicationListener(ApplicationListener listener) {
        this.applicationListeners.remove(listener);
    }

    public void removeAllListeners() {
        this.applicationListeners.clear();
    }

    protected Collection getApplicationListeners() {
        return this.applicationListeners;
    }
}

