/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.context.event;

import com.bea.core.repackaged.aopalliance.intercept.MethodInterceptor;
import com.bea.core.repackaged.aopalliance.intercept.MethodInvocation;
import com.bea.core.repackaged.springframework.beans.factory.InitializingBean;
import com.bea.core.repackaged.springframework.context.ApplicationEvent;
import com.bea.core.repackaged.springframework.context.ApplicationEventPublisher;
import com.bea.core.repackaged.springframework.context.ApplicationEventPublisherAware;
import java.lang.reflect.Constructor;

public class EventPublicationInterceptor
implements MethodInterceptor,
ApplicationEventPublisherAware,
InitializingBean {
    private Constructor applicationEventClassConstructor;
    private ApplicationEventPublisher applicationEventPublisher;

    public void setApplicationEventClass(Class applicationEventClass) {
        if (ApplicationEvent.class.equals(applicationEventClass) || !ApplicationEvent.class.isAssignableFrom(applicationEventClass)) {
            throw new IllegalArgumentException("applicationEventClass needs to extend ApplicationEvent");
        }
        try {
            this.applicationEventClassConstructor = applicationEventClass.getConstructor(Object.class);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("applicationEventClass [" + applicationEventClass.getName() + "] does not have the required Object constructor: " + ex);
        }
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.applicationEventClassConstructor == null) {
            throw new IllegalArgumentException("applicationEventClass is required");
        }
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object retVal = invocation.proceed();
        ApplicationEvent event = (ApplicationEvent)this.applicationEventClassConstructor.newInstance(invocation.getThis());
        this.applicationEventPublisher.publishEvent(event);
        return retVal;
    }
}

