/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.context.support;

import com.bea.core.repackaged.springframework.context.MessageSourceResolvable;
import com.bea.core.repackaged.springframework.util.ObjectUtils;
import com.bea.core.repackaged.springframework.util.StringUtils;
import java.io.Serializable;

public class DefaultMessageSourceResolvable
implements MessageSourceResolvable,
Serializable {
    private final String[] codes;
    private final Object[] arguments;
    private final String defaultMessage;

    public DefaultMessageSourceResolvable(String code) {
        this(new String[]{code}, null, null);
    }

    public DefaultMessageSourceResolvable(String[] codes) {
        this(codes, null, null);
    }

    public DefaultMessageSourceResolvable(String[] codes, String defaultMessage) {
        this(codes, null, defaultMessage);
    }

    public DefaultMessageSourceResolvable(String[] codes, Object[] arguments) {
        this(codes, arguments, null);
    }

    public DefaultMessageSourceResolvable(String[] codes, Object[] arguments, String defaultMessage) {
        this.codes = codes;
        this.arguments = arguments;
        this.defaultMessage = defaultMessage;
    }

    public DefaultMessageSourceResolvable(MessageSourceResolvable resolvable) {
        this(resolvable.getCodes(), resolvable.getArguments(), resolvable.getDefaultMessage());
    }

    public String[] getCodes() {
        return this.codes;
    }

    public String getCode() {
        return this.codes != null && this.codes.length > 0 ? this.codes[this.codes.length - 1] : null;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    protected final String resolvableToString() {
        StringBuffer buf = new StringBuffer();
        buf.append("codes [").append(StringUtils.arrayToDelimitedString(this.codes, ","));
        buf.append("]; arguments [" + StringUtils.arrayToDelimitedString(this.arguments, ","));
        buf.append("]; default message [").append(this.defaultMessage).append(']');
        return buf.toString();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.resolvableToString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MessageSourceResolvable)) {
            return false;
        }
        MessageSourceResolvable otherResolvable = (MessageSourceResolvable)other;
        return ObjectUtils.nullSafeEquals(this.getCodes(), otherResolvable.getCodes());
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.getCodes());
    }
}

