/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.context.support;

import com.bea.core.repackaged.springframework.context.HierarchicalMessageSource;
import com.bea.core.repackaged.springframework.context.MessageSource;
import com.bea.core.repackaged.springframework.context.MessageSourceResolvable;
import com.bea.core.repackaged.springframework.context.NoSuchMessageException;
import java.util.Locale;

public class DelegatingMessageSource
implements HierarchicalMessageSource {
    private MessageSource parentMessageSource;

    public void setParentMessageSource(MessageSource parent) {
        this.parentMessageSource = parent;
    }

    public MessageSource getParentMessageSource() {
        return this.parentMessageSource;
    }

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        if (this.parentMessageSource != null) {
            return this.parentMessageSource.getMessage(code, args, defaultMessage, locale);
        }
        return defaultMessage;
    }

    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        if (this.parentMessageSource != null) {
            return this.parentMessageSource.getMessage(code, args, locale);
        }
        throw new NoSuchMessageException(code, locale);
    }

    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        if (this.parentMessageSource != null) {
            return this.parentMessageSource.getMessage(resolvable, locale);
        }
        if (resolvable.getDefaultMessage() != null) {
            return resolvable.getDefaultMessage();
        }
        String[] codes = resolvable.getCodes();
        String code = codes != null && codes.length > 0 ? codes[0] : null;
        throw new NoSuchMessageException(code, locale);
    }
}

