/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.core;

import com.bea.core.repackaged.springframework.core.AttributeAccessor;
import com.bea.core.repackaged.springframework.util.Assert;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public abstract class AttributeAccessorSupport
implements AttributeAccessor,
Serializable {
    private final Map attributes = new LinkedHashMap();

    public void setAttribute(String name, Object value) {
        Assert.notNull(name, "Name must not be null");
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.removeAttribute(name);
        }
    }

    public Object getAttribute(String name) {
        Assert.notNull(name, "Name must not be null");
        return this.attributes.get(name);
    }

    public Object removeAttribute(String name) {
        Assert.notNull(name, "Name must not be null");
        return this.attributes.remove(name);
    }

    public boolean hasAttribute(String name) {
        Assert.notNull(name, "Name must not be null");
        return this.attributes.containsKey(name);
    }

    public String[] attributeNames() {
        Set attributeNames = this.attributes.keySet();
        return attributeNames.toArray(new String[attributeNames.size()]);
    }

    protected void copyAttributesFrom(AttributeAccessor source) {
        Assert.notNull(source, "Source must not be null");
        String[] attributeNames = source.attributeNames();
        for (int i = 0; i < attributeNames.length; ++i) {
            String attributeName = attributeNames[i];
            this.setAttribute(attributeName, source.getAttribute(attributeName));
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AttributeAccessorSupport)) {
            return false;
        }
        AttributeAccessorSupport that = (AttributeAccessorSupport)other;
        return ((Object)this.attributes).equals(that.attributes);
    }

    public int hashCode() {
        return ((Object)this.attributes).hashCode();
    }
}

