/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.core;

import com.bea.core.repackaged.springframework.core.GenericTypeResolver;
import com.bea.core.repackaged.springframework.util.ClassUtils;
import com.bea.core.repackaged.springframework.util.ReflectionUtils;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class BridgeMethodResolver {
    public static Method findBridgedMethod(Method method) {
        if (method == null || !method.isBridge()) {
            return method;
        }
        ArrayList<Method> arrayList = new ArrayList<Method>();
        Method[] methodArray = ReflectionUtils.getAllDeclaredMethods(method.getDeclaringClass());
        for (int i = 0; i < methodArray.length; ++i) {
            Method method2 = methodArray[i];
            if (!BridgeMethodResolver.isBridgedCandidateFor(method2, method)) continue;
            arrayList.add(method2);
        }
        Method method3 = arrayList.size() == 1 ? (Method)arrayList.get(0) : BridgeMethodResolver.searchCandidates(arrayList, method);
        if (method3 == null) {
            throw new IllegalStateException("Unable to locate bridged method for bridge method '" + method + "'");
        }
        return method3;
    }

    private static Method searchCandidates(List list, Method method) {
        Map map = GenericTypeResolver.getTypeVariableMap(method.getDeclaringClass());
        for (int i = 0; i < list.size(); ++i) {
            Method method2 = (Method)list.get(i);
            if (!BridgeMethodResolver.isBridgeMethodFor(method, method2, map)) continue;
            return method2;
        }
        return null;
    }

    private static boolean isBridgedCandidateFor(Method method, Method method2) {
        return !method.isBridge() && !method.equals(method2) && method.getName().equals(method2.getName()) && method.getParameterTypes().length == method2.getParameterTypes().length;
    }

    static boolean isBridgeMethodFor(Method method, Method method2, Map map) {
        if (BridgeMethodResolver.isResolvedTypeMatch(method2, method, map)) {
            return true;
        }
        Method method3 = BridgeMethodResolver.findGenericDeclaration(method);
        return method3 != null && BridgeMethodResolver.isResolvedTypeMatch(method3, method2, map);
    }

    private static Method findGenericDeclaration(Method method) {
        Class[] classArray;
        Class<?> clazz = method.getDeclaringClass().getSuperclass();
        while (!Object.class.equals(clazz)) {
            classArray = BridgeMethodResolver.searchForMatch(clazz, method);
            if (classArray != null && !classArray.isBridge()) {
                return classArray;
            }
            clazz = clazz.getSuperclass();
        }
        classArray = ClassUtils.getAllInterfacesForClass(method.getDeclaringClass());
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz2 = classArray[i];
            Method method2 = BridgeMethodResolver.searchForMatch(clazz2, method);
            if (method2 == null || method2.isBridge()) continue;
            return method2;
        }
        return null;
    }

    private static boolean isResolvedTypeMatch(Method method, Method method2, Map map) {
        Class<?>[] classArray;
        Type[] typeArray = method.getGenericParameterTypes();
        if (typeArray.length != (classArray = method2.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < typeArray.length; ++i) {
            Type type;
            Type type2 = typeArray[i];
            Class<?> clazz = classArray[i];
            if (clazz.isArray() && (type = GenericTypeResolver.getRawType(type2, map)) instanceof GenericArrayType) {
                if (clazz.getComponentType().equals(GenericTypeResolver.resolveType(((GenericArrayType)type).getGenericComponentType(), map))) break;
                return false;
            }
            if (clazz.equals(GenericTypeResolver.resolveType(type2, map))) continue;
            return false;
        }
        return true;
    }

    private static Method searchForMatch(Class clazz, Method method) {
        return ReflectionUtils.findMethod(clazz, method.getName(), method.getParameterTypes());
    }
}

