/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.core.enums;

import com.bea.core.repackaged.springframework.core.enums.AbstractCachingLabeledEnumResolver;
import com.bea.core.repackaged.springframework.core.enums.LabeledEnum;
import com.bea.core.repackaged.springframework.util.Assert;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.TreeSet;

public class StaticLabeledEnumResolver
extends AbstractCachingLabeledEnumResolver {
    private static final StaticLabeledEnumResolver INSTANCE = new StaticLabeledEnumResolver();

    public static StaticLabeledEnumResolver instance() {
        return INSTANCE;
    }

    protected Set findLabeledEnums(Class type) {
        TreeSet<Object> typeEnums = new TreeSet<Object>();
        Field[] fields = type.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers()) || !type.isAssignableFrom(field.getType())) continue;
            try {
                Object value = field.get(null);
                Assert.isTrue(value instanceof LabeledEnum, "Field value must be a LabeledEnum instance");
                typeEnums.add(value);
                continue;
            }
            catch (IllegalAccessException e) {
                this.logger.warn((Object)("Unable to access field value " + field), (Throwable)e);
            }
        }
        return typeEnums;
    }
}

