/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.core.style;

import com.bea.core.repackaged.springframework.core.style.ToStringStyler;
import com.bea.core.repackaged.springframework.core.style.ValueStyler;
import com.bea.core.repackaged.springframework.util.Assert;
import com.bea.core.repackaged.springframework.util.ClassUtils;
import com.bea.core.repackaged.springframework.util.ObjectUtils;

public class DefaultToStringStyler
implements ToStringStyler {
    private final ValueStyler valueStyler;

    public DefaultToStringStyler(ValueStyler valueStyler) {
        Assert.notNull(valueStyler, "ValueStyler must not be null");
        this.valueStyler = valueStyler;
    }

    protected final ValueStyler getValueStyler() {
        return this.valueStyler;
    }

    public void styleStart(StringBuffer buffer, Object obj) {
        if (!obj.getClass().isArray()) {
            buffer.append('[').append(ClassUtils.getShortName(obj.getClass()));
            this.styleIdentityHashCode(buffer, obj);
        } else {
            buffer.append('[');
            this.styleIdentityHashCode(buffer, obj);
            buffer.append(' ');
            this.styleValue(buffer, obj);
        }
    }

    private void styleIdentityHashCode(StringBuffer buffer, Object obj) {
        buffer.append('@');
        buffer.append(ObjectUtils.getIdentityHexString(obj));
    }

    public void styleEnd(StringBuffer buffer, Object o) {
        buffer.append(']');
    }

    public void styleField(StringBuffer buffer, String fieldName, Object value) {
        this.styleFieldStart(buffer, fieldName);
        this.styleValue(buffer, value);
        this.styleFieldEnd(buffer, fieldName);
    }

    protected void styleFieldStart(StringBuffer buffer, String fieldName) {
        buffer.append(' ').append(fieldName).append(" = ");
    }

    protected void styleFieldEnd(StringBuffer buffer, String fieldName) {
    }

    public void styleValue(StringBuffer buffer, Object value) {
        buffer.append(this.valueStyler.style(value));
    }

    public void styleFieldSeparator(StringBuffer buffer) {
        buffer.append(',');
    }
}

