/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.core.task;

import com.bea.core.repackaged.springframework.core.task.AsyncTaskExecutor;
import com.bea.core.repackaged.springframework.util.Assert;
import com.bea.core.repackaged.springframework.util.ClassUtils;
import com.bea.core.repackaged.springframework.util.ConcurrencyThrottleSupport;
import com.bea.core.repackaged.springframework.util.CustomizableThreadCreator;
import java.io.Serializable;

public class SimpleAsyncTaskExecutor
extends CustomizableThreadCreator
implements AsyncTaskExecutor,
Serializable {
    public static final String DEFAULT_THREAD_NAME_PREFIX = ClassUtils.getShortName(SimpleAsyncTaskExecutor.class) + "-";
    public static final int UNBOUNDED_CONCURRENCY = -1;
    public static final int NO_CONCURRENCY = 0;
    private final ConcurrencyThrottleAdapter concurrencyThrottle = new ConcurrencyThrottleAdapter();

    public SimpleAsyncTaskExecutor() {
    }

    public SimpleAsyncTaskExecutor(String threadNamePrefix) {
        super(threadNamePrefix);
    }

    public void setConcurrencyLimit(int concurrencyLimit) {
        this.concurrencyThrottle.setConcurrencyLimit(concurrencyLimit);
    }

    public int getConcurrencyLimit() {
        return this.concurrencyThrottle.getConcurrencyLimit();
    }

    public boolean isThrottleActive() {
        return this.concurrencyThrottle.isThrottleActive();
    }

    public void execute(Runnable task) {
        this.execute(task, Long.MAX_VALUE);
    }

    public void execute(Runnable task, long startTimeout) {
        Assert.notNull(task, "Runnable must not be null");
        if (this.isThrottleActive() && startTimeout > 0L) {
            this.concurrencyThrottle.beforeAccess();
            this.doExecute(new ConcurrencyThrottlingRunnable(task));
        } else {
            this.doExecute(task);
        }
    }

    protected void doExecute(Runnable task) {
        this.createThread(task).start();
    }

    private class ConcurrencyThrottlingRunnable
    implements Runnable {
        private final Runnable target;

        public ConcurrencyThrottlingRunnable(Runnable target) {
            this.target = target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.target.run();
                Object var2_1 = null;
                SimpleAsyncTaskExecutor.this.concurrencyThrottle.afterAccess();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                SimpleAsyncTaskExecutor.this.concurrencyThrottle.afterAccess();
                throw throwable;
            }
        }
    }

    private static class ConcurrencyThrottleAdapter
    extends ConcurrencyThrottleSupport {
        private ConcurrencyThrottleAdapter() {
        }

        protected void beforeAccess() {
            super.beforeAccess();
        }

        protected void afterAccess() {
            super.afterAccess();
        }
    }
}

