/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.core.type.classreading;

import com.bea.core.repackaged.springframework.asm.ClassReader;
import com.bea.core.repackaged.springframework.core.io.DefaultResourceLoader;
import com.bea.core.repackaged.springframework.core.io.Resource;
import com.bea.core.repackaged.springframework.core.io.ResourceLoader;
import com.bea.core.repackaged.springframework.core.type.classreading.MetadataReader;
import com.bea.core.repackaged.springframework.core.type.classreading.MetadataReaderFactory;
import com.bea.core.repackaged.springframework.core.type.classreading.SimpleMetadataReader;
import com.bea.core.repackaged.springframework.util.ClassUtils;
import java.io.IOException;
import java.io.InputStream;

public class SimpleMetadataReaderFactory
implements MetadataReaderFactory {
    private final ResourceLoader resourceLoader;

    public SimpleMetadataReaderFactory() {
        this.resourceLoader = new DefaultResourceLoader();
    }

    public SimpleMetadataReaderFactory(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader != null ? resourceLoader : new DefaultResourceLoader();
    }

    public SimpleMetadataReaderFactory(ClassLoader classLoader) {
        this.resourceLoader = classLoader != null ? new DefaultResourceLoader(classLoader) : new DefaultResourceLoader();
    }

    public MetadataReader getMetadataReader(String className) throws IOException {
        String resourcePath = "classpath:" + ClassUtils.convertClassNameToResourcePath(className) + ".class";
        return this.getMetadataReader(this.resourceLoader.getResource(resourcePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataReader getMetadataReader(Resource resource) throws IOException {
        InputStream is = resource.getInputStream();
        try {
            SimpleMetadataReader simpleMetadataReader = new SimpleMetadataReader(new ClassReader(is));
            return simpleMetadataReader;
        }
        finally {
            is.close();
        }
    }
}

