/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.dao.annotation;

import com.bea.core.repackaged.springframework.aop.framework.Advised;
import com.bea.core.repackaged.springframework.aop.framework.ProxyConfig;
import com.bea.core.repackaged.springframework.aop.framework.ProxyFactory;
import com.bea.core.repackaged.springframework.aop.support.AopUtils;
import com.bea.core.repackaged.springframework.beans.BeansException;
import com.bea.core.repackaged.springframework.beans.factory.BeanClassLoaderAware;
import com.bea.core.repackaged.springframework.beans.factory.BeanFactory;
import com.bea.core.repackaged.springframework.beans.factory.BeanFactoryAware;
import com.bea.core.repackaged.springframework.beans.factory.ListableBeanFactory;
import com.bea.core.repackaged.springframework.beans.factory.config.BeanPostProcessor;
import com.bea.core.repackaged.springframework.core.Ordered;
import com.bea.core.repackaged.springframework.dao.annotation.PersistenceExceptionTranslationAdvisor;
import com.bea.core.repackaged.springframework.stereotype.Repository;
import com.bea.core.repackaged.springframework.util.Assert;
import com.bea.core.repackaged.springframework.util.ClassUtils;
import java.lang.annotation.Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceExceptionTranslationPostProcessor
extends ProxyConfig
implements BeanPostProcessor,
BeanClassLoaderAware,
BeanFactoryAware,
Ordered {
    private Class<? extends Annotation> repositoryAnnotationType = Repository.class;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private PersistenceExceptionTranslationAdvisor persistenceExceptionTranslationAdvisor;

    public void setRepositoryAnnotationType(Class<? extends Annotation> repositoryAnnotationType) {
        Assert.notNull(repositoryAnnotationType, "'requiredAnnotationType' must not be null");
        this.repositoryAnnotationType = repositoryAnnotationType;
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (!(beanFactory instanceof ListableBeanFactory)) {
            throw new IllegalArgumentException("Cannot use PersistenceExceptionTranslator autodetection without ListableBeanFactory");
        }
        this.persistenceExceptionTranslationAdvisor = new PersistenceExceptionTranslationAdvisor((ListableBeanFactory)beanFactory, this.repositoryAnnotationType);
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class targetClass;
        Class clazz = targetClass = bean instanceof Advised ? ((Advised)bean).getTargetSource().getTargetClass() : bean.getClass();
        if (targetClass == null) {
            return bean;
        }
        if (AopUtils.canApply(this.persistenceExceptionTranslationAdvisor, targetClass)) {
            if (bean instanceof Advised) {
                ((Advised)bean).addAdvisor(this.persistenceExceptionTranslationAdvisor);
                return bean;
            }
            ProxyFactory proxyFactory = new ProxyFactory(bean);
            proxyFactory.copyFrom(this);
            proxyFactory.addAdvisor(this.persistenceExceptionTranslationAdvisor);
            return proxyFactory.getProxy(this.beanClassLoader);
        }
        return bean;
    }
}

