/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.dao.support;

import com.bea.core.repackaged.aopalliance.intercept.MethodInterceptor;
import com.bea.core.repackaged.aopalliance.intercept.MethodInvocation;
import com.bea.core.repackaged.springframework.beans.BeansException;
import com.bea.core.repackaged.springframework.beans.factory.BeanFactory;
import com.bea.core.repackaged.springframework.beans.factory.BeanFactoryAware;
import com.bea.core.repackaged.springframework.beans.factory.BeanFactoryUtils;
import com.bea.core.repackaged.springframework.beans.factory.InitializingBean;
import com.bea.core.repackaged.springframework.beans.factory.ListableBeanFactory;
import com.bea.core.repackaged.springframework.dao.support.ChainedPersistenceExceptionTranslator;
import com.bea.core.repackaged.springframework.dao.support.DataAccessUtils;
import com.bea.core.repackaged.springframework.dao.support.PersistenceExceptionTranslator;
import com.bea.core.repackaged.springframework.util.Assert;
import com.bea.core.repackaged.springframework.util.ReflectionUtils;
import java.util.Iterator;
import java.util.Map;

public class PersistenceExceptionTranslationInterceptor
implements MethodInterceptor,
BeanFactoryAware,
InitializingBean {
    private PersistenceExceptionTranslator persistenceExceptionTranslator;

    public PersistenceExceptionTranslationInterceptor() {
    }

    public PersistenceExceptionTranslationInterceptor(PersistenceExceptionTranslator persistenceExceptionTranslator) {
        this.setPersistenceExceptionTranslator(persistenceExceptionTranslator);
    }

    public PersistenceExceptionTranslationInterceptor(ListableBeanFactory beanFactory) {
        this.persistenceExceptionTranslator = this.detectPersistenceExceptionTranslators(beanFactory);
    }

    public void setPersistenceExceptionTranslator(PersistenceExceptionTranslator pet) {
        Assert.notNull(pet, "PersistenceExceptionTranslator must not be null");
        this.persistenceExceptionTranslator = pet;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (this.persistenceExceptionTranslator == null) {
            if (!(beanFactory instanceof ListableBeanFactory)) {
                throw new IllegalArgumentException("Cannot use PersistenceExceptionTranslator autodetection without ListableBeanFactory");
            }
            this.persistenceExceptionTranslator = this.detectPersistenceExceptionTranslators((ListableBeanFactory)beanFactory);
        }
    }

    public void afterPropertiesSet() {
        if (this.persistenceExceptionTranslator == null) {
            throw new IllegalArgumentException("Property 'persistenceExceptionTranslator' is required");
        }
    }

    protected PersistenceExceptionTranslator detectPersistenceExceptionTranslators(ListableBeanFactory beanFactory) {
        Map pets = BeanFactoryUtils.beansOfTypeIncludingAncestors(beanFactory, PersistenceExceptionTranslator.class, false, false);
        if (pets.isEmpty()) {
            throw new IllegalStateException("No persistence exception translators found in bean factory. Cannot perform exception translation.");
        }
        ChainedPersistenceExceptionTranslator cpet = new ChainedPersistenceExceptionTranslator();
        Iterator it = pets.values().iterator();
        while (it.hasNext()) {
            cpet.addDelegate((PersistenceExceptionTranslator)it.next());
        }
        return cpet;
    }

    public Object invoke(MethodInvocation mi) throws Throwable {
        try {
            return mi.proceed();
        }
        catch (RuntimeException ex) {
            if (ReflectionUtils.declaresException(mi.getMethod(), ex.getClass())) {
                throw ex;
            }
            throw DataAccessUtils.translateIfNecessary(ex, this.persistenceExceptionTranslator);
        }
    }
}

