/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.ejb.access;

import com.bea.core.repackaged.aopalliance.intercept.MethodInvocation;
import com.bea.core.repackaged.springframework.ejb.access.AbstractSlsbInvokerInterceptor;
import com.bea.core.repackaged.springframework.ejb.access.EjbAccessException;
import com.bea.core.repackaged.springframework.remoting.RemoteConnectFailureException;
import com.bea.core.repackaged.springframework.remoting.RemoteLookupFailureException;
import com.bea.core.repackaged.springframework.remoting.rmi.RmiClientInterceptorUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public abstract class AbstractRemoteSlsbInvokerInterceptor
extends AbstractSlsbInvokerInterceptor {
    private Class homeInterface;
    private boolean refreshHomeOnConnectFailure = false;
    private volatile boolean homeAsComponent = false;

    public void setHomeInterface(Class homeInterface) {
        if (homeInterface != null && !homeInterface.isInterface()) {
            throw new IllegalArgumentException("Home interface class [" + homeInterface.getClass() + "] is not an interface");
        }
        this.homeInterface = homeInterface;
    }

    public void setRefreshHomeOnConnectFailure(boolean refreshHomeOnConnectFailure) {
        this.refreshHomeOnConnectFailure = refreshHomeOnConnectFailure;
    }

    protected boolean isHomeRefreshable() {
        return this.refreshHomeOnConnectFailure;
    }

    protected Object lookup() throws NamingException {
        Object homeObject = super.lookup();
        if (this.homeInterface != null) {
            try {
                homeObject = PortableRemoteObject.narrow((Object)homeObject, (Class)this.homeInterface);
            }
            catch (ClassCastException ex) {
                throw new RemoteLookupFailureException("Could not narrow EJB home stub to home interface [" + this.homeInterface.getName() + "]", ex);
            }
        }
        return homeObject;
    }

    protected Method getCreateMethod(Object home) throws EjbAccessException {
        if (this.homeAsComponent) {
            return null;
        }
        if (!(home instanceof EJBHome)) {
            this.homeAsComponent = true;
            return null;
        }
        return super.getCreateMethod(home);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        try {
            return this.doInvoke(invocation);
        }
        catch (RemoteConnectFailureException ex) {
            return this.handleRemoteConnectFailure(invocation, ex);
        }
        catch (RemoteException ex) {
            if (this.isConnectFailure(ex)) {
                return this.handleRemoteConnectFailure(invocation, ex);
            }
            throw ex;
        }
    }

    protected boolean isConnectFailure(RemoteException ex) {
        return RmiClientInterceptorUtils.isConnectFailure(ex);
    }

    private Object handleRemoteConnectFailure(MethodInvocation invocation, Exception ex) throws Throwable {
        if (this.refreshHomeOnConnectFailure) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Could not connect to remote EJB [" + this.getJndiName() + "] - retrying"), (Throwable)ex);
            } else if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Could not connect to remote EJB [" + this.getJndiName() + "] - retrying"));
            }
            return this.refreshAndRetry(invocation);
        }
        throw ex;
    }

    protected Object refreshAndRetry(MethodInvocation invocation) throws Throwable {
        try {
            this.refreshHome();
        }
        catch (NamingException ex) {
            throw new RemoteLookupFailureException("Failed to locate remote EJB [" + this.getJndiName() + "]", ex);
        }
        return this.doInvoke(invocation);
    }

    protected abstract Object doInvoke(MethodInvocation var1) throws Throwable;

    protected EJBObject newSessionBeanInstance() throws NamingException, InvocationTargetException {
        Object ejbInstance;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Trying to create reference to remote EJB");
        }
        if (!((ejbInstance = this.create()) instanceof EJBObject)) {
            throw new RemoteLookupFailureException("EJB instance [" + ejbInstance + "] is not a Remote Stateless Session Bean");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Obtained reference to remote EJB: " + ejbInstance));
        }
        return (EJBObject)ejbInstance;
    }

    protected void removeSessionBeanInstance(EJBObject ejb) {
        if (ejb != null && !this.homeAsComponent) {
            try {
                ejb.remove();
            }
            catch (Throwable ex) {
                this.logger.warn((Object)"Could not invoke 'remove' on remote EJB proxy", ex);
            }
        }
    }
}

