/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.ejb.interceptor;

import com.bea.core.repackaged.springframework.beans.factory.BeanFactory;
import com.bea.core.repackaged.springframework.beans.factory.access.BeanFactoryLocator;
import com.bea.core.repackaged.springframework.beans.factory.access.BeanFactoryReference;
import com.bea.core.repackaged.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import com.bea.core.repackaged.springframework.context.ApplicationContext;
import com.bea.core.repackaged.springframework.context.access.ContextSingletonBeanFactoryLocator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.interceptor.InvocationContext;

public class SpringBeanAutowiringInterceptor {
    private final Map<Object, BeanFactoryReference> beanFactoryReferences = new WeakHashMap<Object, BeanFactoryReference>();

    @PostConstruct
    @PostActivate
    public void autowireBean(InvocationContext invocationContext) {
        Object target = invocationContext.getTarget();
        AutowiredAnnotationBeanPostProcessor bpp = new AutowiredAnnotationBeanPostProcessor();
        this.configureBeanPostProcessor(bpp, target);
        bpp.setBeanFactory(this.getBeanFactory(target));
        bpp.processInjection(target);
    }

    protected void configureBeanPostProcessor(AutowiredAnnotationBeanPostProcessor processor, Object target) {
    }

    protected BeanFactory getBeanFactory(Object target) {
        BeanFactory factory = this.getBeanFactoryReference(target).getFactory();
        if (factory instanceof ApplicationContext) {
            factory = ((ApplicationContext)factory).getAutowireCapableBeanFactory();
        }
        return factory;
    }

    protected BeanFactoryReference getBeanFactoryReference(Object target) {
        String key = this.getBeanFactoryLocatorKey(target);
        BeanFactoryReference ref = this.getBeanFactoryLocator(target).useBeanFactory(key);
        this.beanFactoryReferences.put(target, ref);
        return ref;
    }

    protected BeanFactoryLocator getBeanFactoryLocator(Object target) {
        return ContextSingletonBeanFactoryLocator.getInstance();
    }

    protected String getBeanFactoryLocatorKey(Object target) {
        return null;
    }

    @PreDestroy
    @PrePassivate
    public void releaseBean(InvocationContext invocationContext) {
        this.doReleaseBean(invocationContext.getTarget());
    }

    protected void doReleaseBean(Object target) {
        BeanFactoryReference ref = this.beanFactoryReferences.remove(target);
        if (ref != null) {
            ref.release();
        }
    }
}

