/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.instrument.classloading;

import com.bea.core.repackaged.apache.commons.logging.Log;
import com.bea.core.repackaged.apache.commons.logging.LogFactory;
import com.bea.core.repackaged.springframework.instrument.classloading.LoadTimeWeaver;
import com.bea.core.repackaged.springframework.instrument.classloading.SimpleThrowawayClassLoader;
import com.bea.core.repackaged.springframework.util.Assert;
import com.bea.core.repackaged.springframework.util.ClassUtils;
import com.bea.core.repackaged.springframework.util.ReflectionUtils;
import java.lang.instrument.ClassFileTransformer;
import java.lang.reflect.Method;

public class ReflectiveLoadTimeWeaver
implements LoadTimeWeaver {
    private static final String ADD_TRANSFORMER_METHOD_NAME = "addTransformer";
    private static final String GET_THROWAWAY_CLASS_LOADER_METHOD_NAME = "getThrowawayClassLoader";
    private static final Log logger = LogFactory.getLog(ReflectiveLoadTimeWeaver.class);
    private final ClassLoader classLoader;
    private final Method addTransformerMethod;
    private final Method getThrowawayClassLoaderMethod;

    public ReflectiveLoadTimeWeaver() {
        this(ClassUtils.getDefaultClassLoader());
    }

    public ReflectiveLoadTimeWeaver(ClassLoader classLoader) {
        Assert.notNull(classLoader, "ClassLoader must not be null");
        this.classLoader = classLoader;
        this.addTransformerMethod = ClassUtils.getMethodIfAvailable(this.classLoader.getClass(), ADD_TRANSFORMER_METHOD_NAME, new Class[]{ClassFileTransformer.class});
        if (this.addTransformerMethod == null) {
            throw new IllegalStateException("ClassLoader [" + classLoader.getClass().getName() + "] does NOT provide an " + "'addTransformer(ClassFileTransformer)' method.");
        }
        this.getThrowawayClassLoaderMethod = ClassUtils.getMethodIfAvailable(this.classLoader.getClass(), GET_THROWAWAY_CLASS_LOADER_METHOD_NAME, new Class[0]);
        if (this.getThrowawayClassLoaderMethod == null && logger.isInfoEnabled()) {
            logger.info((Object)("The ClassLoader [" + classLoader.getClass().getName() + "] does NOT provide a " + "'getThrowawayClassLoader()' method; SimpleThrowawayClassLoader will be used instead."));
        }
    }

    public void addTransformer(ClassFileTransformer transformer) {
        Assert.notNull(transformer, "Transformer must not be null");
        ReflectionUtils.invokeMethod(this.addTransformerMethod, this.classLoader, new Object[]{transformer});
    }

    public ClassLoader getInstrumentableClassLoader() {
        return this.classLoader;
    }

    public ClassLoader getThrowawayClassLoader() {
        if (this.getThrowawayClassLoaderMethod != null) {
            return (ClassLoader)ReflectionUtils.invokeMethod(this.getThrowawayClassLoaderMethod, this.classLoader, new Object[0]);
        }
        return new SimpleThrowawayClassLoader(this.classLoader);
    }
}

