/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.jca.cci.connection;

import com.bea.core.repackaged.apache.commons.logging.Log;
import com.bea.core.repackaged.apache.commons.logging.LogFactory;
import com.bea.core.repackaged.springframework.jca.cci.CannotGetCciConnectionException;
import com.bea.core.repackaged.springframework.jca.cci.connection.ConnectionHolder;
import com.bea.core.repackaged.springframework.transaction.support.TransactionSynchronizationAdapter;
import com.bea.core.repackaged.springframework.transaction.support.TransactionSynchronizationManager;
import com.bea.core.repackaged.springframework.util.Assert;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;

public abstract class ConnectionFactoryUtils {
    private static final Log logger = LogFactory.getLog((Class)ConnectionFactoryUtils.class);

    public static Connection getConnection(ConnectionFactory cf) throws CannotGetCciConnectionException {
        return ConnectionFactoryUtils.getConnection(cf, null);
    }

    public static Connection getConnection(ConnectionFactory cf, ConnectionSpec spec) throws CannotGetCciConnectionException {
        try {
            if (spec != null) {
                Assert.notNull(cf, "No ConnectionFactory specified");
                return cf.getConnection(spec);
            }
            return ConnectionFactoryUtils.doGetConnection(cf);
        }
        catch (ResourceException ex) {
            throw new CannotGetCciConnectionException("Could not get CCI Connection", ex);
        }
    }

    public static Connection doGetConnection(ConnectionFactory cf) throws ResourceException {
        Assert.notNull(cf, "No ConnectionFactory specified");
        ConnectionHolder conHolder = (ConnectionHolder)TransactionSynchronizationManager.getResource(cf);
        if (conHolder != null) {
            return conHolder.getConnection();
        }
        logger.debug((Object)"Opening CCI Connection");
        Connection con = cf.getConnection();
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            logger.debug((Object)"Registering transaction synchronization for CCI Connection");
            conHolder = new ConnectionHolder(con);
            conHolder.setSynchronizedWithTransaction(true);
            TransactionSynchronizationManager.registerSynchronization(new ConnectionSynchronization(conHolder, cf));
            TransactionSynchronizationManager.bindResource(cf, conHolder);
        }
        return con;
    }

    public static boolean isConnectionTransactional(Connection con, ConnectionFactory cf) {
        if (cf == null) {
            return false;
        }
        ConnectionHolder conHolder = (ConnectionHolder)TransactionSynchronizationManager.getResource(cf);
        return conHolder != null && conHolder.getConnection() == con;
    }

    public static void releaseConnection(Connection con, ConnectionFactory cf) {
        try {
            ConnectionFactoryUtils.doReleaseConnection(con, cf);
        }
        catch (ResourceException ex) {
            logger.debug((Object)"Could not close CCI Connection", (Throwable)ex);
        }
        catch (Throwable ex) {
            logger.debug((Object)"Unexpected exception on closing CCI Connection", ex);
        }
    }

    public static void doReleaseConnection(Connection con, ConnectionFactory cf) throws ResourceException {
        if (con == null || ConnectionFactoryUtils.isConnectionTransactional(con, cf)) {
            return;
        }
        con.close();
    }

    private static class ConnectionSynchronization
    extends TransactionSynchronizationAdapter {
        private final ConnectionHolder connectionHolder;
        private final ConnectionFactory connectionFactory;
        private boolean holderActive = true;

        public ConnectionSynchronization(ConnectionHolder connectionHolder, ConnectionFactory connectionFactory) {
            this.connectionHolder = connectionHolder;
            this.connectionFactory = connectionFactory;
        }

        public void suspend() {
            if (this.holderActive) {
                TransactionSynchronizationManager.unbindResource(this.connectionFactory);
            }
        }

        public void resume() {
            if (this.holderActive) {
                TransactionSynchronizationManager.bindResource(this.connectionFactory, this.connectionHolder);
            }
        }

        public void beforeCompletion() {
            TransactionSynchronizationManager.unbindResource(this.connectionFactory);
            this.holderActive = false;
            ConnectionFactoryUtils.releaseConnection(this.connectionHolder.getConnection(), this.connectionFactory);
        }
    }
}

