/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.jca.cci.connection;

import com.bea.core.repackaged.springframework.core.NamedThreadLocal;
import com.bea.core.repackaged.springframework.jca.cci.connection.DelegatingConnectionFactory;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionSpec;

public class ConnectionSpecConnectionFactoryAdapter
extends DelegatingConnectionFactory {
    private ConnectionSpec connectionSpec;
    private final ThreadLocal threadBoundSpec = new NamedThreadLocal("Current CCI ConnectionSpec");

    public void setConnectionSpec(ConnectionSpec connectionSpec) {
        this.connectionSpec = connectionSpec;
    }

    public void setConnectionSpecForCurrentThread(ConnectionSpec spec) {
        this.threadBoundSpec.set(spec);
    }

    public void removeConnectionSpecFromCurrentThread() {
        this.threadBoundSpec.set(null);
    }

    public final Connection getConnection() throws ResourceException {
        ConnectionSpec threadSpec = (ConnectionSpec)this.threadBoundSpec.get();
        if (threadSpec != null) {
            return this.doGetConnection(threadSpec);
        }
        return this.doGetConnection(this.connectionSpec);
    }

    protected Connection doGetConnection(ConnectionSpec spec) throws ResourceException {
        if (this.getTargetConnectionFactory() == null) {
            throw new IllegalStateException("targetConnectionFactory is required");
        }
        if (spec != null) {
            return this.getTargetConnectionFactory().getConnection(spec);
        }
        return this.getTargetConnectionFactory().getConnection();
    }
}

