/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.jca.cci.core.support;

import com.bea.core.repackaged.springframework.dao.support.DaoSupport;
import com.bea.core.repackaged.springframework.jca.cci.CannotGetCciConnectionException;
import com.bea.core.repackaged.springframework.jca.cci.connection.ConnectionFactoryUtils;
import com.bea.core.repackaged.springframework.jca.cci.core.CciTemplate;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;

public abstract class CciDaoSupport
extends DaoSupport {
    private CciTemplate cciTemplate;

    public final void setConnectionFactory(ConnectionFactory connectionFactory) {
        if (this.cciTemplate == null || connectionFactory != this.cciTemplate.getConnectionFactory()) {
            this.cciTemplate = this.createCciTemplate(connectionFactory);
        }
    }

    protected CciTemplate createCciTemplate(ConnectionFactory connectionFactory) {
        return new CciTemplate(connectionFactory);
    }

    public final ConnectionFactory getConnectionFactory() {
        return this.cciTemplate.getConnectionFactory();
    }

    public final void setCciTemplate(CciTemplate cciTemplate) {
        this.cciTemplate = cciTemplate;
    }

    public final CciTemplate getCciTemplate() {
        return this.cciTemplate;
    }

    protected final void checkDaoConfig() {
        if (this.cciTemplate == null) {
            throw new IllegalArgumentException("'connectionFactory' or 'cciTemplate' is required");
        }
    }

    protected final CciTemplate getCciTemplate(ConnectionSpec connectionSpec) {
        return this.getCciTemplate().getDerivedTemplate(connectionSpec);
    }

    protected final Connection getConnection() throws CannotGetCciConnectionException {
        return ConnectionFactoryUtils.getConnection(this.getConnectionFactory());
    }

    protected final void releaseConnection(Connection con) {
        ConnectionFactoryUtils.releaseConnection(con, this.getConnectionFactory());
    }
}

