/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.jca.endpoint;

import com.bea.core.repackaged.aopalliance.intercept.MethodInterceptor;
import com.bea.core.repackaged.aopalliance.intercept.MethodInvocation;
import com.bea.core.repackaged.springframework.aop.framework.ProxyFactory;
import com.bea.core.repackaged.springframework.aop.support.DelegatingIntroductionInterceptor;
import com.bea.core.repackaged.springframework.jca.endpoint.AbstractMessageEndpointFactory;
import com.bea.core.repackaged.springframework.util.ReflectionUtils;
import javax.resource.ResourceException;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.transaction.xa.XAResource;

public class GenericMessageEndpointFactory
extends AbstractMessageEndpointFactory {
    private Object messageListener;

    public void setMessageListener(Object messageListener) {
        this.messageListener = messageListener;
    }

    public MessageEndpoint createEndpoint(XAResource xaResource) throws UnavailableException {
        GenericMessageEndpoint endpoint = (GenericMessageEndpoint)super.createEndpoint(xaResource);
        ProxyFactory proxyFactory = new ProxyFactory(this.messageListener);
        DelegatingIntroductionInterceptor introduction = new DelegatingIntroductionInterceptor(endpoint);
        introduction.suppressInterface(MethodInterceptor.class);
        proxyFactory.addAdvice(introduction);
        return (MessageEndpoint)proxyFactory.getProxy();
    }

    protected AbstractMessageEndpointFactory.AbstractMessageEndpoint createEndpointInternal() throws UnavailableException {
        return new GenericMessageEndpoint();
    }

    public static class InternalResourceException
    extends RuntimeException {
        protected InternalResourceException(ResourceException cause) {
            super(cause);
        }
    }

    private class GenericMessageEndpoint
    extends AbstractMessageEndpointFactory.AbstractMessageEndpoint
    implements MethodInterceptor {
        private GenericMessageEndpoint() {
        }

        public Object invoke(MethodInvocation methodInvocation) throws Throwable {
            boolean applyDeliveryCalls;
            boolean bl = applyDeliveryCalls = !this.hasBeforeDeliveryBeenCalled();
            if (applyDeliveryCalls) {
                try {
                    this.beforeDelivery(null);
                }
                catch (ResourceException ex) {
                    if (ReflectionUtils.declaresException(methodInvocation.getMethod(), ((Object)((Object)ex)).getClass())) {
                        throw ex;
                    }
                    throw new InternalResourceException(ex);
                }
            }
            try {
                Object ex = methodInvocation.proceed();
                return ex;
            }
            catch (Throwable ex) {
                this.onEndpointException(ex);
                throw ex;
            }
            finally {
                if (applyDeliveryCalls) {
                    try {
                        this.afterDelivery();
                    }
                    catch (ResourceException ex) {
                        if (ReflectionUtils.declaresException(methodInvocation.getMethod(), ((Object)((Object)ex)).getClass())) {
                            throw ex;
                        }
                        throw new InternalResourceException(ex);
                    }
                }
            }
        }

        protected ClassLoader getEndpointClassLoader() {
            return GenericMessageEndpointFactory.this.messageListener.getClass().getClassLoader();
        }
    }
}

