/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.jmx.access;

import com.bea.core.repackaged.apache.commons.logging.Log;
import com.bea.core.repackaged.apache.commons.logging.LogFactory;
import com.bea.core.repackaged.springframework.jmx.MBeanServerNotFoundException;
import com.bea.core.repackaged.springframework.jmx.support.JmxUtils;
import java.io.IOException;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

class ConnectorDelegate {
    private static final Log logger = LogFactory.getLog((Class)ConnectorDelegate.class);
    private JMXConnector connector;

    ConnectorDelegate() {
    }

    public MBeanServerConnection connect(JMXServiceURL serviceUrl, String agentId) throws MBeanServerNotFoundException {
        if (serviceUrl != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Connecting to remote MBeanServer at URL [" + serviceUrl + "]"));
            }
            try {
                this.connector = JMXConnectorFactory.connect(serviceUrl);
                return this.connector.getMBeanServerConnection();
            }
            catch (IOException ex) {
                throw new MBeanServerNotFoundException("Could not connect to remote MBeanServer [" + serviceUrl + "]", ex);
            }
        }
        logger.debug((Object)"Attempting to locate local MBeanServer");
        return JmxUtils.locateMBeanServer(agentId);
    }

    public void close() {
        if (this.connector != null) {
            try {
                this.connector.close();
            }
            catch (IOException ex) {
                logger.debug((Object)"Could not close JMX connector", (Throwable)ex);
            }
        }
    }
}

