/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.jmx.export.assembler;

import com.bea.core.repackaged.springframework.beans.factory.BeanClassLoaderAware;
import com.bea.core.repackaged.springframework.beans.factory.InitializingBean;
import com.bea.core.repackaged.springframework.jmx.export.assembler.AbstractConfigurableMBeanInfoAssembler;
import com.bea.core.repackaged.springframework.util.ClassUtils;
import com.bea.core.repackaged.springframework.util.StringUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class InterfaceBasedMBeanInfoAssembler
extends AbstractConfigurableMBeanInfoAssembler
implements BeanClassLoaderAware,
InitializingBean {
    private Class[] managedInterfaces;
    private Properties interfaceMappings;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private Map resolvedInterfaceMappings;

    public void setManagedInterfaces(Class[] managedInterfaces) {
        if (managedInterfaces != null) {
            for (int x = 0; x < managedInterfaces.length; ++x) {
                if (managedInterfaces[x].isInterface()) continue;
                throw new IllegalArgumentException("Management interface [" + managedInterfaces[x].getName() + "] is no interface");
            }
        }
        this.managedInterfaces = managedInterfaces;
    }

    public void setInterfaceMappings(Properties mappings) {
        this.interfaceMappings = mappings;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    public void afterPropertiesSet() {
        if (this.interfaceMappings != null) {
            this.resolvedInterfaceMappings = this.resolveInterfaceMappings(this.interfaceMappings);
        }
    }

    private Map resolveInterfaceMappings(Properties mappings) {
        HashMap<String, Class[]> resolvedMappings = new HashMap<String, Class[]>(mappings.size());
        Enumeration<?> en = mappings.propertyNames();
        while (en.hasMoreElements()) {
            String beanKey = (String)en.nextElement();
            String[] classNames = StringUtils.commaDelimitedListToStringArray(mappings.getProperty(beanKey));
            Class[] classes = this.resolveClassNames(classNames, beanKey);
            resolvedMappings.put(beanKey, classes);
        }
        return resolvedMappings;
    }

    private Class[] resolveClassNames(String[] classNames, String beanKey) {
        Class[] classes = new Class[classNames.length];
        for (int x = 0; x < classes.length; ++x) {
            Class cls = ClassUtils.resolveClassName(classNames[x].trim(), this.beanClassLoader);
            if (!cls.isInterface()) {
                throw new IllegalArgumentException("Class [" + classNames[x] + "] mapped to bean key [" + beanKey + "] is no interface");
            }
            classes[x] = cls;
        }
        return classes;
    }

    protected boolean includeReadAttribute(Method method, String beanKey) {
        return this.isPublicInInterface(method, beanKey);
    }

    protected boolean includeWriteAttribute(Method method, String beanKey) {
        return this.isPublicInInterface(method, beanKey);
    }

    protected boolean includeOperation(Method method, String beanKey) {
        return this.isPublicInInterface(method, beanKey);
    }

    private boolean isPublicInInterface(Method method, String beanKey) {
        return (method.getModifiers() & 1) > 0 && this.isDeclaredInInterface(method, beanKey);
    }

    private boolean isDeclaredInInterface(Method method, String beanKey) {
        Class[] ifaces = null;
        if (this.resolvedInterfaceMappings != null) {
            ifaces = (Class[])this.resolvedInterfaceMappings.get(beanKey);
        }
        if (ifaces == null && (ifaces = this.managedInterfaces) == null) {
            ifaces = ClassUtils.getAllInterfacesForClass(method.getDeclaringClass());
        }
        if (ifaces != null) {
            for (int i = 0; i < ifaces.length; ++i) {
                Method[] methods = ifaces[i].getMethods();
                for (int j = 0; j < methods.length; ++j) {
                    Method ifaceMethod = methods[j];
                    if (!ifaceMethod.getName().equals(method.getName()) || !Arrays.equals(ifaceMethod.getParameterTypes(), method.getParameterTypes())) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

