/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.jmx.support;

import com.bea.core.repackaged.springframework.util.ClassUtils;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ObjectNameManager {
    private static final boolean getInstanceAvailable = ClassUtils.hasMethod(ObjectName.class, "getInstance", new Class[]{String.class});

    public static ObjectName getInstance(Object objectName) throws MalformedObjectNameException {
        if (objectName instanceof ObjectName) {
            return (ObjectName)objectName;
        }
        if (!(objectName instanceof String)) {
            throw new MalformedObjectNameException("Invalid ObjectName value type [" + objectName.getClass().getName() + "]: only ObjectName and String supported.");
        }
        return ObjectNameManager.getInstance((String)objectName);
    }

    public static ObjectName getInstance(String objectName) throws MalformedObjectNameException {
        if (getInstanceAvailable) {
            return ObjectName.getInstance(objectName);
        }
        return new ObjectName(objectName);
    }

    public static ObjectName getInstance(String domainName, String key, String value) throws MalformedObjectNameException {
        if (getInstanceAvailable) {
            return ObjectName.getInstance(domainName, key, value);
        }
        return new ObjectName(domainName, key, value);
    }

    public static ObjectName getInstance(String domainName, Hashtable properties) throws MalformedObjectNameException {
        if (getInstanceAvailable) {
            return ObjectName.getInstance(domainName, properties);
        }
        return new ObjectName(domainName, properties);
    }
}

