/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.jmx.support;

import com.bea.core.repackaged.springframework.beans.factory.FactoryBean;
import com.bea.core.repackaged.springframework.beans.factory.InitializingBean;
import com.bea.core.repackaged.springframework.jmx.MBeanServerNotFoundException;
import java.lang.reflect.InvocationTargetException;
import javax.management.MBeanServer;

public class WebLogicMBeanServerFactoryBean
implements FactoryBean,
InitializingBean {
    private static final String WEBLOGIC_JMX_HELPER_CLASS = "weblogic.management.Helper";
    private static final String GET_MBEAN_HOME_METHOD = "getMBeanHome";
    private static final String GET_MBEAN_SERVER_METHOD = "getMBeanServer";
    private String username = "weblogic";
    private String password = "weblogic";
    private String serverUrl = "t3://localhost:7001";
    private String serverName = "server";
    private MBeanServer mbeanServer;

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void afterPropertiesSet() throws MBeanServerNotFoundException {
        try {
            Class<?> helperClass = this.getClass().getClassLoader().loadClass(WEBLOGIC_JMX_HELPER_CLASS);
            Class[] argTypes = new Class[]{String.class, String.class, String.class, String.class};
            Object[] args = new Object[]{this.username, this.password, this.serverUrl, this.serverName};
            Object mbeanHome = helperClass.getMethod(GET_MBEAN_HOME_METHOD, argTypes).invoke(null, args);
            this.mbeanServer = (MBeanServer)mbeanHome.getClass().getMethod(GET_MBEAN_SERVER_METHOD, null).invoke(mbeanHome, null);
        }
        catch (ClassNotFoundException ex) {
            throw new MBeanServerNotFoundException("Could not find WebLogic's JMX Helper class", ex);
        }
        catch (InvocationTargetException ex) {
            throw new MBeanServerNotFoundException("WebLogic's JMX Helper.getMBeanHome/getMBeanServer method failed", ex.getTargetException());
        }
        catch (Exception ex) {
            throw new MBeanServerNotFoundException("Could not access WebLogic's JMX Helper.getMBeanHome/getMBeanServer method", ex);
        }
    }

    public Object getObject() {
        return this.mbeanServer;
    }

    public Class getObjectType() {
        return this.mbeanServer != null ? this.mbeanServer.getClass() : MBeanServer.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

